<?php
/**
 * Background Mask Style - Layer Blob.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Mask_Layer_Blob
 *
 * @since 4.15.0
 */
class ET_Builder_Mask_Layer_Blob extends ET_Builder_Background_Mask_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Layer Blob', 'et-builder' ),
			'svgContent' => array(
				'default'          => array(
					'landscape' => '<path fill-opacity=".2" d="M1563.9,270.35c-7.56-5.89-9.15-17.15-6.22-26.28a35.21,35.21,0,0,1,18.3-20.81c16.44-7.72,45.26-2.27,45.33,19.61,0,8.95-5,17.45-12.08,22.91s-16,8.12-24.94,8.93C1577.2,275.36,1569.52,274.73,1563.9,270.35ZM1920,0V257.8q-21.74-23.88-46.58-46.35c-120.07-108.24-330.64-127.15-434-2.82-96.83,116.49-72,311-190.33,405.5-66.33,53-157.62,56.81-240,77.14S837.37,767.76,837,852.64s81.93,132.7,138.57,181.23c77.74,66.61,100.39,114,97.62,217.68-2.07,77.73,4,141.69,64.37,188.45H0V0ZM915.94,473.16c-8.74,40.26,19.23,76.38,55,95.31,58.7,31,135.19,19.25,190.09-14.4,42.32-25.93,75.61-66.93,91.82-113.9,13.42-38.89,15.28-82.59.14-120.84s-48.51-70-88.78-78.42-86,9.39-106.06,45.29c-10.78,19.28-14,42.08-24.79,61.37a93.18,93.18,0,0,1-6.15,9.56c-14.08,19.33-34.79,33.45-54.33,47.69-19.85,14.48-42.9,31.47-52.72,54.88A77.22,77.22,0,0,0,915.94,473.16ZM671.61,699.81a46.88,46.88,0,0,0-4.68-9.31c-14-21.44-43.39-26.88-67.81-20.46-36.4,9.57-74.36,62.06-45.67,97.11,10.75,13.13,28.35,19.46,45.31,19.13C640.84,785.48,688.85,746.1,671.61,699.81Zm155.72,530.1a31.69,31.69,0,0,0-5.68-12,21.33,21.33,0,0,0-9.9-7c-4.57-1.52-8-.83-12.11,1.32a21.92,21.92,0,0,0-10,10.48,19,19,0,0,0,.25,16.16c2.76,5.21,8.15,8.54,13.7,10.53,6.09,2.19,13.37,2.88,18.65-.87C828.1,1244.28,829,1236.87,827.33,1229.91Zm55-5.49c-.16,13.52-6.35,24.62-3.77,38.73,2.7,14.81,14,26.78,24.74,33.67,24.08,15.5,50.53,14.89,67.84-1.57s24.92-48.25,19.54-81.53l.4,4c-4.06-28.83-18-58.52-36.83-78.55s-42.26-30-61.95-26.42c-15.39,2.81-29.32,16.25-28.48,38.3C864.79,1175.24,882.67,1200.67,882.38,1224.42Zm770.84,162.78c-37.63,19.33-80,37.33-123.65,52.8H1920V1159.48C1849.68,1253.37,1759.09,1332.79,1653.22,1387.2Z"/>
									<path fill-opacity=".5" d="M1621.31,242.87c0,8.95-5,17.45-12.08,22.91s-16,8.12-24.94,8.93c-7.09.65-14.77,0-20.39-4.36-7.56-5.89-9.15-17.15-6.22-26.28a35.21,35.21,0,0,1,18.3-20.81C1592.42,215.54,1621.24,221,1621.31,242.87ZM1920,1440V1294.47A788.66,788.66,0,0,1,1717.55,1440ZM1920,0V170.18c-76-67.47-182.35-105.59-280.83-103.24-78.3,1.86-151.64,29.29-200.84,87.89-104.16,124-70.95,336.48-199.66,436-72.12,55.74-173.36,57.31-264.26,77.07S785.94,746.2,788,838.59s94.77,146.81,159,201.26c88.23,74.75,114.73,126.94,114.64,239.78,0,61.6,4.5,115.36,33.4,160.37H0V0ZM971.63,583.69c60.69,33.94,139.29,22,195.48-13.77,43.31-27.54,77.19-71.38,93.44-121.8,13.46-41.75,15-88.79-1-130.11s-50.56-75.82-92.07-85.25-88.39,9.32-108.73,47.79c-10.92,20.67-14,45.18-25,65.85a100.26,100.26,0,0,1-6.58,10.73c-14.08,19.33-34.79,33.45-54.33,47.69-19.85,14.48-42.9,31.47-52.72,54.88a77.22,77.22,0,0,0-4.27,13.46C902.19,519.33,932.49,561.8,971.63,583.69ZM597.7,793.78c50.52-1.65,107.52-46.59,86-98.11A51.27,51.27,0,0,0,678,685.33c-17.16-23.75-52.56-29.32-81.78-21.69C552.63,675,507.91,734.45,543,773.17,556.09,787.68,577.33,794.45,597.7,793.78Zm229.63,436.13a31.69,31.69,0,0,0-5.68-12,21.33,21.33,0,0,0-9.9-7c-4.57-1.52-8-.83-12.11,1.32a21.92,21.92,0,0,0-10,10.48,19,19,0,0,0,.25,16.16c2.76,5.21,8.15,8.54,13.7,10.53,6.09,2.19,13.37,2.88,18.65-.87C828.1,1244.28,829,1236.87,827.33,1229.91Zm71.37,80.61c27.74,18.17,58.48,17.74,78.85-1.11s29.72-55.5,24-94l.4,4.66c-4.26-33.37-20-67.83-41.55-91.18s-48.64-35.15-71.57-31.19c-17.93,3.09-34.33,18.48-33.7,44,.68,27.94,21.06,57.52,20.35,85-.4,15.64-7.77,28.4-5,44.74C873.38,1288.48,886.37,1302.44,898.7,1310.52Z"/>
									<path d="M1621.31,242.87c0,8.95-5,17.45-12.08,22.91s-16,8.12-24.94,8.93c-7.09.65-14.77,0-20.39-4.36-7.56-5.89-9.15-17.15-6.22-26.28a35.21,35.21,0,0,1,18.3-20.81C1592.42,215.54,1621.24,221,1621.31,242.87ZM1920,1440V1294.47A788.66,788.66,0,0,1,1717.55,1440Zm-875.71-160.37c0,61.6,4.49,115.36,33.39,160.37H0V0H1920V170.18c-76-67.47-182.35-105.59-280.83-103.24-84.73-2-165.38,25-218.2,87.89-104.15,124-71,336.48-199.66,436-72.12,55.74-173.36,57.31-264.26,77.07S768.59,746.2,770.59,838.59s94.78,146.81,159,201.26C1017.87,1114.6,1044.37,1166.79,1044.29,1279.63ZM971.63,583.69c60.69,33.94,139.29,22,195.48-13.77,43.31-27.54,77.19-71.38,93.44-121.8,13.46-41.75,15-88.79-1-130.11s-50.56-75.82-92.07-85.25-88.39,9.32-108.73,47.79c-10.92,20.67-14,45.18-25,65.85a100.26,100.26,0,0,1-6.58,10.73c-14.08,19.33-34.79,33.45-54.33,47.69-19.85,14.48-42.9,31.47-52.72,54.88a77.22,77.22,0,0,0-4.27,13.46C902.19,519.33,932.49,561.8,971.63,583.69ZM702.31,705.78a67.79,67.79,0,0,0-3.6-14c-12.48-33-49.34-48-82.88-45.38-50,3.91-113.57,66.46-85.57,122,10.48,20.79,31.72,34,53.92,37.84C639.22,815.79,712.36,773.84,702.31,705.78Zm125,524.13a31.69,31.69,0,0,0-5.68-12,21.33,21.33,0,0,0-9.9-7c-4.57-1.52-8-.83-12.11,1.32a21.92,21.92,0,0,0-10,10.48,19,19,0,0,0,.25,16.16c2.76,5.21,8.15,8.54,13.7,10.53,6.09,2.19,13.37,2.88,18.65-.87C828.1,1244.28,829,1236.87,827.33,1229.91Zm177.9-18.29.32,5c-3.89-35.78-20.87-72.39-44.93-96.88s-54.72-36.37-81.13-31.44c-20.65,3.86-39.9,20.9-39.94,48.32,0,30,22.44,61.26,20.81,90.81-.92,16.84-9.74,30.79-7.05,48.29,2.82,18.36,17.3,33,31.19,41.32,31.26,18.73,66.52,17.35,90.44-3.53S1010.66,1252.9,1005.23,1211.62Z"/>',
					'portrait'  => '<path fill-opacity=".2" d="M1701,1001.36c-10.23-8-12.37-23.19-8.41-35.53a47.59,47.59,0,0,1,24.75-28.16c22.23-10.44,61.2-3.07,61.3,26.52,0,12.11-6.76,23.61-16.34,31s-21.68,11-33.73,12.07C1719,1008.14,1708.6,1007.28,1701,1001.36ZM1920,0V816.64c-141.15-36-295.51-9.19-387.3,101.25-131,157.55-97.32,420.59-257.41,548.41-89.71,71.62-213.17,76.83-324.61,104.33S718.43,1674.07,717.9,1788.87c-.54,114.62,110.8,179.46,187.4,245.09,105.14,90.09,135.77,154.12,132,294.41-2.47,92.77,3.63,171.05,61.23,231.63H0V0ZM824.69,1275.65c-11.83,54.45,26,103.3,74.46,128.9,79.38,42,182.83,26,257.08-19.47,57.23-35.07,102.26-90.52,124.17-154,18.15-52.59,20.66-111.69.19-163.42s-65.6-94.68-120.07-106.06-116.27,12.69-143.43,61.25c-14.59,26.08-19,56.9-33.53,83a127.75,127.75,0,0,1-8.31,12.94c-19,26.14-47,45.23-73.48,64.5-26.85,19.57-58,42.55-71.3,74.21A104.38,104.38,0,0,0,824.69,1275.65ZM494.25,1582.17a63.9,63.9,0,0,0-6.32-12.59c-18.93-29-58.69-36.35-91.71-27.67-49.23,12.94-100.58,83.94-61.77,131.33,14.54,17.76,38.34,26.32,61.28,25.88C452.63,1698,517.57,1644.78,494.25,1582.17Zm210.6,716.92a42.9,42.9,0,0,0-7.68-16.25,28.82,28.82,0,0,0-13.39-9.51c-6.18-2-10.78-1.12-16.38,1.79a29.54,29.54,0,0,0-13.57,14.17c-3,6.91-3.19,15.19.34,21.86,3.72,7,11,11.55,18.52,14.24,8.24,3,18.08,3.89,25.22-1.18C705.9,2318.54,707.06,2308.51,704.85,2299.09Zm221-21.89.54,5.45c-5.48-39-24.3-79.14-49.8-106.23s-57.16-40.6-83.78-35.73c-20.82,3.8-39.65,22-38.52,51.8,1.24,32.67,25.42,67.06,25,99.17-.22,18.3-8.59,33.3-5.1,52.39,3.65,20,19,36.22,33.46,45.54,32.57,21,68.34,20.13,91.75-2.13S933.12,2322.21,925.83,2277.2ZM1715.91,2560H1920V2454a999.53,999.53,0,0,1-98.2,57.8C1788.77,2528.79,1753.06,2545,1715.91,2560Z"/>
									<path fill-opacity=".5" d="M1778.65,964.19c0,12.11-6.76,23.61-16.34,31s-21.68,11-33.73,12.07c-9.59.88-20,0-27.57-5.9-10.23-8-12.37-23.19-8.41-35.53a47.59,47.59,0,0,1,24.75-28.16C1739.58,927.23,1778.55,934.6,1778.65,964.19ZM1920,0V736.93a530.62,530.62,0,0,0-117.2-10.67c-105.89,2.52-205.08,39.62-271.62,118.87-140.86,167.74-96,455.06-270,589.61-97.53,75.38-234.45,77.51-357.39,104.23s-254.88,105.94-252.17,230.89c2.7,124.76,128.18,198.55,215.11,272.2,119.32,101.09,155.16,171.68,155,324.28,0,73,4.66,137.79,32.07,193.66H0V0ZM900,1425.13c82.08,45.9,188.38,29.7,264.38-18.62,58.56-37.24,104.4-96.53,126.37-164.73,18.2-56.46,20.24-120.08-1.3-176s-68.38-102.55-124.52-115.29-119.54,12.6-147,64.63c-14.78,27.95-19,61.1-33.74,89.06a137.3,137.3,0,0,1-8.9,14.51c-19,26.14-47,45.23-73.48,64.5-26.85,19.57-58,42.55-71.3,74.21a104.38,104.38,0,0,0-5.78,18.21C806.1,1338.09,847.07,1395.53,900,1425.13ZM394.29,1709.27c68.32-2.24,145.42-63,116.37-132.7a69.28,69.28,0,0,0-7.81-14c-23.2-32.13-71.08-39.65-110.6-29.34-58.9,15.37-119.38,95.76-72,148.13C338,1701,366.74,1710.17,394.29,1709.27Zm310.56,589.82a42.9,42.9,0,0,0-7.68-16.25,28.82,28.82,0,0,0-13.39-9.51c-6.18-2-10.78-1.12-16.38,1.79a29.54,29.54,0,0,0-13.57,14.17c-3,6.91-3.19,15.19.34,21.86,3.72,7,11,11.55,18.52,14.24,8.24,3,18.08,3.89,25.22-1.18C705.9,2318.54,707.06,2308.51,704.85,2299.09Zm96.52,109c37.52,24.58,79.09,24,106.64-1.49s40.2-75.07,32.45-127.18l.54,6.31c-5.76-45.13-27-91.73-56.2-123.32S819,2114.9,788,2120.25c-24.25,4.18-46.42,25-45.58,59.47.93,37.78,28.48,77.78,27.53,114.9-.55,21.15-10.51,38.4-6.76,60.51C767.14,2378.31,784.7,2397.19,801.37,2408.11Z"/>
									<path d="M1778.65,964.19c0,12.11-6.76,23.61-16.34,31s-21.68,11-33.73,12.07c-9.59.88-20,0-27.57-5.9-10.23-8-12.37-23.19-8.41-35.53a47.59,47.59,0,0,1,24.75-28.16C1739.58,927.23,1778.55,934.6,1778.65,964.19ZM998.27,2366.34c-.06,73,4.65,137.79,32.07,193.66H0V0H1920V736.93a530.62,530.62,0,0,0-117.2-10.67c-114.59-2.71-223.66,33.79-295.1,118.87-140.85,167.74-96,455.06-270,589.61-97.54,75.38-234.46,77.51-357.39,104.23s-254.88,105.94-252.18,230.89c2.7,124.76,128.18,198.55,215.11,272.2C962.54,2143.15,998.39,2213.74,998.27,2366.34ZM900,1425.13c82.08,45.9,188.38,29.7,264.38-18.62,58.56-37.24,104.4-96.53,126.37-164.73,18.2-56.46,20.24-120.08-1.3-176s-68.38-102.55-124.52-115.29-119.54,12.6-147,64.63c-14.78,27.95-19,61.1-33.74,89.06a137.3,137.3,0,0,1-8.9,14.51c-19,26.14-47,45.23-73.48,64.5-26.85,19.57-58,42.55-71.3,74.21a104.38,104.38,0,0,0-5.78,18.21C806.1,1338.09,847.07,1395.53,900,1425.13ZM535.77,1590.25a91.53,91.53,0,0,0-4.87-18.92c-16.88-44.69-66.73-64.92-112.09-61.37-67.63,5.29-153.59,89.89-115.73,164.94,14.18,28.12,42.9,45.94,72.93,51.17C450.45,1739,549.36,1682.29,535.77,1590.25Zm169.08,708.84a42.9,42.9,0,0,0-7.68-16.25,28.82,28.82,0,0,0-13.39-9.51c-6.18-2-10.78-1.12-16.38,1.79a29.54,29.54,0,0,0-13.57,14.17c-3,6.91-3.19,15.19.34,21.86,3.72,7,11,11.55,18.52,14.24,8.24,3,18.08,3.89,25.22-1.18C705.9,2318.54,707.06,2308.51,704.85,2299.09Zm240.6-24.74.43,6.77c-5.26-48.39-28.22-97.9-60.77-131s-74-49.19-109.72-42.52c-27.92,5.22-54,28.27-54,65.35,0,40.63,30.35,82.85,28.15,122.82-1.25,22.77-13.18,41.63-9.54,65.3,3.83,24.83,23.4,44.63,42.19,55.88,42.28,25.33,90,23.47,122.31-4.77S952.79,2330.19,945.45,2274.35Z"/>',
					'square'    => '<path fill-opacity=".2" d="M1787.6,508.31c-9.13-7.11-11-20.7-7.5-31.72a42.41,42.41,0,0,1,22.08-25.12c19.84-9.32,54.62-2.74,54.71,23.66,0,10.81-6,21.08-14.59,27.66s-19.34,9.8-30.09,10.78C1803.65,514.35,1794.38,513.59,1787.6,508.31ZM1920,0V332.19c-106.89-11-214.22,19.33-282.61,101.62-116.87,140.61-86.85,375.36-229.73,489.44-80.06,63.91-190.24,68.56-289.69,93.1s-207.28,92.32-207.75,194.77c-.48,102.29,98.88,160.16,167.25,218.74,93.83,80.4,121.16,137.54,117.83,262.74-2.5,93.78,4.83,171,77.62,227.4H0V0ZM1005.52,753.09c-10.55,48.6,23.21,92.2,66.45,115,70.85,37.44,163.17,23.23,229.44-17.38,51.07-31.31,91.26-80.79,110.82-137.48,16.2-46.94,18.44-99.69.16-145.85s-58.55-84.5-107.15-94.65-103.77,11.32-128,54.66c-13,23.27-16.91,50.78-29.92,74.07a115.11,115.11,0,0,1-7.42,11.54c-17,23.33-42,40.37-65.58,57.56-24,17.47-51.78,38-63.63,66.24A93.48,93.48,0,0,0,1005.52,753.09Zm-294.9,273.56a56.48,56.48,0,0,0-5.65-11.23c-16.88-25.88-52.37-32.45-81.84-24.7-43.93,11.55-89.76,74.91-55.13,117.21,13,15.85,34.22,23.49,54.7,23.1C673.48,1130.06,731.43,1082.53,710.62,1026.65Zm188,639.83a38.29,38.29,0,0,0-6.85-14.51,25.79,25.79,0,0,0-12-8.49c-5.52-1.82-9.63-1-14.63,1.6A26.44,26.44,0,0,0,853,1657.72c-2.68,6.17-2.84,13.57.31,19.51,3.32,6.29,9.83,10.31,16.53,12.71,7.36,2.64,16.14,3.48,22.51-1C899.5,1683.83,900.55,1674.88,898.57,1666.48Zm197.22-19.54.48,4.86c-4.89-34.8-21.69-70.63-44.44-94.81s-51-36.23-74.78-31.89c-18.58,3.4-35.39,19.62-34.38,46.23,1.11,29.17,22.69,59.85,22.35,88.52-.2,16.33-7.67,29.71-4.56,46.75,3.26,17.87,16.95,32.32,29.86,40.64,29.07,18.71,61,18,81.88-1.9S1102.29,1687.11,1095.79,1646.94ZM1746.31,1920H1920v-76.82q-12.18,6.75-24.6,13.14C1850,1879.64,1799,1901.34,1746.31,1920Z"/>
									<path fill-opacity=".5" d="M1856.89,475.13c0,10.81-6,21.08-14.59,27.66s-19.34,9.8-30.09,10.78c-8.56.78-17.83,0-24.61-5.26-9.13-7.11-11-20.7-7.5-31.72a42.41,42.41,0,0,1,22.08-25.12C1822,442.15,1856.8,448.73,1856.89,475.13ZM1920,0V263.76c-13.93-1-27.81-1.3-41.56-1-94.5,2.25-183,35.36-242.41,106.08-125.71,149.71-85.63,406.13-241,526.2-87,67.28-209.24,69.18-319,93s-227.47,94.55-225,206.06c2.4,111.34,114.39,177.19,192,242.92,106.49,90.22,138.48,153.22,138.37,289.41-.05,74.32,5.43,139.2,40.28,193.51H0V0ZM932.11,1559.94c.83,33.72,25.42,69.42,24.57,102.55-.49,18.87-9.38,34.27-6,54,3.51,20.69,19.18,37.54,34.06,47.29,33.48,21.93,70.59,21.41,95.17-1.34s35.88-67,29-113.49l.48,5.62c-5.14-40.27-24.09-81.86-50.15-110s-58.7-42.42-86.39-37.65C951.15,1510.59,931.36,1529.17,932.11,1559.94ZM725.26,1021.66a62.07,62.07,0,0,0-7-12.48c-20.72-28.67-63.45-35.38-98.71-26.18C567,996.72,513,1068.47,555.34,1115.2c15.85,17.51,41.48,25.68,66.07,24.88C682.38,1138.08,751.19,1083.84,725.26,1021.66Zm128.08,655.57c3.32,6.29,9.83,10.31,16.53,12.71,7.36,2.64,16.14,3.48,22.51-1,7.12-5.06,8.17-14,6.19-22.41a38.29,38.29,0,0,0-6.85-14.51,25.79,25.79,0,0,0-12-8.49c-5.52-1.82-9.63-1-14.63,1.6A26.44,26.44,0,0,0,853,1657.72C850.35,1663.89,850.19,1671.29,853.34,1677.23Zm567-1111.4c-19.23-49.88-61-91.52-111.13-102.89s-106.68,11.24-131.23,57.68c-13.18,25-16.94,54.53-30.11,79.48a121.81,121.81,0,0,1-7.94,12.95c-17,23.33-42,40.37-65.58,57.56-24,17.47-51.78,38-63.63,66.24a93.48,93.48,0,0,0-5.16,16.24c-16.59,55.73,20,107,67.22,133.41,73.25,41,168.12,26.51,235.94-16.62,52.27-33.23,93.17-86.15,112.78-147C1437.7,672.48,1439.53,615.71,1420.3,565.83Z"/>
									<path d="M1856.89,475.13c0,10.81-6,21.08-14.59,27.66s-19.34,9.8-30.09,10.78c-8.56.78-17.83,0-24.61-5.26-9.13-7.11-11-20.7-7.5-31.72a42.41,42.41,0,0,1,22.08-25.12C1822,442.15,1856.8,448.73,1856.89,475.13ZM1160.43,1726.49c0,74.32,5.43,139.2,40.28,193.51H0V0H1920V263.76c-13.93-1-27.81-1.3-41.56-1-102.27-2.42-199.6,30.16-263.36,106.08-125.71,149.71-85.63,406.13-241,526.2-87,67.28-209.24,69.18-319,93s-227.47,94.55-225.05,206.06c2.4,111.34,114.39,177.19,192,242.92C1128.55,1527.3,1160.54,1590.3,1160.43,1726.49Zm-87.69-840c73.25,41,168.12,26.51,235.94-16.62,52.27-33.23,93.17-86.15,112.78-147,16.24-50.39,18.07-107.16-1.16-157s-61-91.52-111.13-102.89-106.68,11.24-131.23,57.68c-13.18,25-16.94,54.53-30.11,79.48a121.81,121.81,0,0,1-7.94,12.95c-17,23.33-42,40.37-65.58,57.56-24,17.47-51.78,38-63.63,66.24a93.48,93.48,0,0,0-5.16,16.24C988.93,808.82,1025.5,860.08,1072.74,886.5ZM747.67,1033.86a81.7,81.7,0,0,0-4.34-16.88c-15.07-39.89-59.55-57.94-100-54.77-60.35,4.72-137.07,80.22-103.28,147.2,12.66,25.09,38.29,41,65.08,45.67C671.53,1166.65,759.81,1116,747.67,1033.86Zm150.9,632.62a38.29,38.29,0,0,0-6.85-14.51,25.79,25.79,0,0,0-12-8.49c-5.52-1.82-9.63-1-14.63,1.6A26.44,26.44,0,0,0,853,1657.72c-2.68,6.17-2.84,13.57.31,19.51,3.32,6.29,9.83,10.31,16.53,12.71,7.36,2.64,16.14,3.48,22.51-1C899.5,1683.83,900.55,1674.88,898.57,1666.48Zm214.72-22.08.39,6c-4.69-43.19-25.19-87.38-54.23-116.94s-66.05-43.9-97.93-37.94c-24.92,4.65-48.16,25.23-48.2,58.32-.05,36.26,27.08,73.94,25.12,109.61-1.12,20.32-11.76,37.15-8.51,58.28,3.41,22.16,20.88,39.83,37.64,49.87,37.74,22.61,80.3,20.95,109.16-4.26S1119.85,1694.23,1113.29,1644.4Z"/>',
				),
				'default-inverted' => array(
					'landscape' => '<path fill-opacity=".2" d="M827.33,1229.91c1.64,7,.77,14.37-5.13,18.57-5.28,3.75-12.56,3.06-18.65.87-5.55-2-10.94-5.32-13.7-10.53a19,19,0,0,1-.25-16.16,21.92,21.92,0,0,1,10-10.48c4.14-2.15,7.54-2.84,12.11-1.32a21.33,21.33,0,0,1,9.9,7A31.69,31.69,0,0,1,827.33,1229.91ZM1920,170.18V1294.47A788.66,788.66,0,0,1,1717.55,1440H1077.68c-28.9-45-33.44-98.77-33.39-160.37.08-112.84-26.42-165-114.65-239.78-64.27-54.45-157.06-109-159-201.26s95.56-151,186.46-170.73,192.14-21.33,264.26-77.07c128.71-99.48,95.51-311.93,199.66-436,52.82-62.91,133.47-89.9,218.2-87.89C1737.65,64.59,1844,102.71,1920,170.18Zm-298.69,72.69c-.07-21.88-28.89-27.33-45.33-19.61a35.21,35.21,0,0,0-18.3,20.81c-2.93,9.13-1.34,20.39,6.22,26.28,5.62,4.38,13.3,5,20.39,4.36,8.91-.81,17.85-3.47,24.94-8.93S1621.34,251.82,1621.31,242.87ZM698.71,691.79c-12.48-33-49.34-48-82.88-45.38-50,3.91-113.57,66.47-85.57,122,10.48,20.79,31.72,34,53.92,37.84,55,9.58,128.18-32.37,118.13-100.43A67.79,67.79,0,0,0,698.71,691.79Zm272.92-108.1c60.69,33.94,139.29,22,195.48-13.77,43.31-27.54,77.19-71.38,93.44-121.8,13.46-41.75,15-88.79-1-130.11s-50.56-75.82-92.07-85.25-88.39,9.32-108.73,47.79c-10.92,20.67-14,45.18-25,65.85a100.26,100.26,0,0,1-6.58,10.73c-14.08,19.33-34.79,33.45-54.33,47.69-19.85,14.48-42.9,31.47-52.72,54.88a77.22,77.22,0,0,0-4.27,13.46C902.19,519.33,932.49,561.8,971.63,583.69Zm33.92,632.93c-3.89-35.78-20.87-72.39-44.93-96.88s-54.72-36.37-81.13-31.44c-20.65,3.86-39.9,20.9-39.94,48.32,0,30,22.44,61.26,20.81,90.81-.92,16.84-9.74,30.79-7.05,48.29,2.82,18.36,17.3,33,31.19,41.32,31.26,18.73,66.52,17.35,90.44-3.53s35.72-60.61,30.29-101.89Z"/>
									<path fill-opacity=".5" d="M915.94,473.16a77.22,77.22,0,0,1,4.27-13.46c9.82-23.41,32.87-40.4,52.72-54.88,19.54-14.24,40.25-28.36,54.33-47.69a93.18,93.18,0,0,0,6.15-9.56c10.78-19.29,14-42.09,24.79-61.37,20.09-35.9,65.79-53.7,106.06-45.29s73.64,40.17,88.78,78.42,13.28,81.95-.14,120.84c-16.21,47-49.5,88-91.82,113.9-54.9,33.65-131.39,45.43-190.09,14.4C935.17,549.54,907.2,513.42,915.94,473.16Zm-94.29,744.73a21.33,21.33,0,0,0-9.9-7c-4.57-1.52-8-.83-12.11,1.32a21.92,21.92,0,0,0-10,10.48,19,19,0,0,0,.25,16.16c2.76,5.21,8.15,8.54,13.7,10.53,6.09,2.19,13.37,2.88,18.65-.87,5.9-4.2,6.77-11.61,5.13-18.57A31.69,31.69,0,0,0,821.65,1217.89ZM1920,170.18V1294.47A788.66,788.66,0,0,1,1717.55,1440H1095c-28.9-45-33.44-98.77-33.4-160.37.09-112.84-26.41-165-114.64-239.78-64.28-54.45-157.06-109-159-201.26s95.56-151,186.46-170.73,192.14-21.33,264.26-77.07c128.71-99.48,95.5-311.93,199.66-436,49.2-58.6,122.54-86,200.84-87.89C1737.65,64.59,1844,102.71,1920,170.18Zm-344,53.08a35.21,35.21,0,0,0-18.3,20.81c-2.93,9.13-1.34,20.39,6.22,26.28,5.62,4.38,13.3,5,20.39,4.36,8.91-.81,17.85-3.47,24.94-8.93s12.11-14,12.08-22.91C1621.24,221,1592.42,215.54,1576,223.26Zm-574,996.78c-4.26-33.37-20-67.83-41.55-91.18s-48.64-35.15-71.57-31.19c-17.93,3.09-34.33,18.48-33.7,44,.68,27.94,21.06,57.52,20.35,85-.4,15.64-7.77,28.4-5,44.74,2.9,17.14,15.89,31.1,28.22,39.18,27.74,18.17,58.48,17.74,78.85-1.11s29.72-55.5,24-94ZM678,685.33c-17.16-23.75-52.56-29.32-81.78-21.69C552.63,675,507.91,734.45,543,773.17c13.13,14.51,34.37,21.28,54.74,20.61,50.52-1.65,107.52-46.59,86-98.11A51.27,51.27,0,0,0,678,685.33Z"/>
									<path d="M671.61,699.81c17.24,46.29-30.77,85.67-72.85,86.47-17,.33-34.56-6-45.31-19.13-28.69-35,9.27-87.54,45.67-97.11,24.42-6.42,53.82-1,67.81,20.46A46.88,46.88,0,0,1,671.61,699.81ZM971,568.47c58.7,31,135.19,19.25,190.09-14.4,42.32-25.93,75.61-66.93,91.82-113.9,13.42-38.89,15.28-82.59.14-120.84s-48.51-70-88.78-78.42-86,9.39-106.06,45.29c-10.78,19.28-14,42.08-24.79,61.37a93.18,93.18,0,0,1-6.15,9.56c-14.08,19.33-34.79,33.45-54.33,47.69-19.85,14.48-42.9,31.47-52.72,54.88a77.22,77.22,0,0,0-4.27,13.46C907.2,513.42,935.17,549.54,971,568.47ZM821.65,1217.89a21.33,21.33,0,0,0-9.9-7c-4.57-1.52-8-.83-12.11,1.32a21.92,21.92,0,0,0-10,10.48,19,19,0,0,0,.25,16.16c2.76,5.21,8.15,8.54,13.7,10.53,6.09,2.19,13.37,2.88,18.65-.87,5.9-4.2,6.77-11.61,5.13-18.57A31.69,31.69,0,0,0,821.65,1217.89ZM1920,257.8v901.68c-70.32,93.89-160.91,173.31-266.78,227.72-37.63,19.33-80,37.33-123.65,52.8h-392c-60.36-46.76-66.44-110.72-64.37-188.45,2.77-103.72-19.88-151.07-97.62-217.68-56.64-48.53-139-96.48-138.57-181.23s89.72-141,172.12-161.37,173.69-24.18,240-77.14c118.38-94.51,93.5-289,190.33-405.5,103.33-124.33,313.9-105.42,434,2.82Q1898.3,233.88,1920,257.8Zm-298.69-14.93c-.07-21.88-28.89-27.33-45.33-19.61a35.21,35.21,0,0,0-18.3,20.81c-2.93,9.13-1.34,20.39,6.22,26.28,5.62,4.38,13.3,5,20.39,4.36,8.91-.81,17.85-3.47,24.94-8.93S1621.34,251.82,1621.31,242.87ZM991.13,1217.75c-4.06-28.83-18-58.52-36.83-78.55s-42.26-30-61.95-26.42c-15.39,2.81-29.32,16.25-28.48,38.3.92,24.16,18.8,49.59,18.51,73.34-.16,13.52-6.35,24.62-3.77,38.73,2.7,14.81,14,26.78,24.74,33.67,24.08,15.5,50.53,14.89,67.84-1.57s24.92-48.25,19.54-81.53Z"/>',
					'portrait'  => '<path fill-opacity=".2" d="M704.85,2299.09c2.21,9.42,1,19.45-6.94,25.12-7.14,5.07-17,4.13-25.22,1.18-7.51-2.69-14.8-7.2-18.52-14.24-3.53-6.67-3.35-15-.34-21.86a29.54,29.54,0,0,1,13.57-14.17c5.6-2.91,10.2-3.84,16.38-1.79a28.82,28.82,0,0,1,13.39,9.51A42.9,42.9,0,0,1,704.85,2299.09ZM1920,736.93V2560H1030.34c-27.42-55.87-32.13-120.7-32.07-193.66.12-152.6-35.73-223.19-155-324.28-86.93-73.65-212.41-147.44-215.11-272.2-2.7-124.95,129.24-204.16,252.18-230.89s259.85-28.85,357.39-104.23c174.07-134.55,129.17-421.87,270-589.61,71.44-85.08,180.51-121.58,295.1-118.87A530.62,530.62,0,0,1,1920,736.93ZM1778.65,964.19c-.1-29.59-39.07-37-61.3-26.52a47.59,47.59,0,0,0-24.75,28.16c-4,12.34-1.82,27.57,8.41,35.53,7.59,5.92,18,6.78,27.57,5.9,12.05-1.09,24.14-4.69,33.73-12.07S1778.7,976.3,1778.65,964.19ZM530.9,1571.33c-16.88-44.69-66.73-64.92-112.09-61.37-67.63,5.29-153.59,89.89-115.73,164.94,14.18,28.12,42.9,45.94,72.93,51.17,74.44,13,173.35-43.78,159.76-135.82A91.53,91.53,0,0,0,530.9,1571.33ZM900,1425.13c82.08,45.9,188.38,29.7,264.38-18.62,58.56-37.24,104.4-96.53,126.37-164.73,18.2-56.46,20.24-120.08-1.3-176s-68.38-102.55-124.52-115.29-119.54,12.6-147,64.63c-14.78,27.95-19,61.1-33.74,89.06a137.3,137.3,0,0,1-8.9,14.51c-19,26.14-47,45.23-73.48,64.5-26.85,19.57-58,42.55-71.3,74.21a104.38,104.38,0,0,0-5.78,18.21C806.1,1338.09,847.07,1395.53,900,1425.13Zm45.88,856c-5.26-48.39-28.22-97.9-60.77-131s-74-49.19-109.72-42.52c-27.92,5.22-54,28.27-54,65.35,0,40.63,30.35,82.85,28.15,122.82-1.25,22.77-13.18,41.63-9.54,65.3,3.83,24.83,23.4,44.63,42.19,55.88,42.28,25.33,90,23.47,122.31-4.77s48.31-82,41-137.81Z"/>
									<path fill-opacity=".5" d="M824.69,1275.65a104.38,104.38,0,0,1,5.78-18.21c13.28-31.66,44.45-54.64,71.3-74.21,26.43-19.27,54.43-38.36,73.48-64.5a127.75,127.75,0,0,0,8.31-12.94c14.58-26.09,18.94-56.91,33.53-83,27.16-48.56,89-72.62,143.43-61.25s99.59,54.33,120.07,106.06,18,110.83-.19,163.42c-21.91,63.53-66.94,119-124.17,154-74.25,45.51-177.7,61.43-257.08,19.47C850.7,1379,812.86,1330.1,824.69,1275.65ZM697.17,2282.84a28.82,28.82,0,0,0-13.39-9.51c-6.18-2-10.78-1.12-16.38,1.79a29.54,29.54,0,0,0-13.57,14.17c-3,6.91-3.19,15.19.34,21.86,3.72,7,11,11.55,18.52,14.24,8.24,3,18.08,3.89,25.22-1.18,8-5.67,9.15-15.7,6.94-25.12A42.9,42.9,0,0,0,697.17,2282.84ZM1920,736.93V2560H1053.81c-27.41-55.87-32.12-120.7-32.07-193.66.12-152.6-35.72-223.19-155-324.28-86.93-73.65-212.41-147.44-215.11-272.2C648.88,1644.91,780.83,1565.7,903.76,1539s259.86-28.85,357.39-104.23c174.08-134.55,129.17-421.87,270-589.61,66.54-79.25,165.73-116.35,271.62-118.87A530.62,530.62,0,0,1,1920,736.93Zm-191.42,270.33c12.05-1.09,24.14-4.69,33.73-12.07s16.39-18.89,16.34-31c-.1-29.59-39.07-37-61.3-26.52a47.59,47.59,0,0,0-24.75,28.16c-4,12.34-1.82,27.57,8.41,35.53C1708.6,1007.28,1719,1008.14,1728.58,1007.26ZM941,2285.75c-5.76-45.13-27-91.73-56.2-123.32S819,2114.9,788,2120.25c-24.25,4.18-46.42,25-45.58,59.47.93,37.78,28.48,77.78,27.53,114.9-.55,21.15-10.51,38.4-6.76,60.51,3.94,23.18,21.5,42.06,38.17,53,37.52,24.58,79.09,24,106.64-1.49s40.2-75.07,32.45-127.18ZM502.85,1562.6c-23.2-32.13-71.08-39.65-110.6-29.34-58.9,15.37-119.38,95.76-72,148.13,17.76,19.62,46.48,28.78,74,27.88,68.32-2.24,145.42-63,116.37-132.7A69.28,69.28,0,0,0,502.85,1562.6Z"/>
									<path d="M925.83,2277.2c7.29,45-3,88-26.42,110.26s-59.18,23.09-91.75,2.13c-14.47-9.32-29.81-25.51-33.46-45.54-3.49-19.09,4.88-34.09,5.1-52.39.39-32.11-23.79-66.5-25-99.17-1.13-29.82,17.7-48,38.52-51.8,26.62-4.87,58.29,8.63,83.78,35.73s44.32,67.24,49.8,106.23Zm-437.9-707.62c-18.93-29-58.69-36.35-91.71-27.67-49.23,12.94-100.58,83.94-61.77,131.33,14.54,17.76,38.34,26.32,61.28,25.88,56.9-1.09,121.84-54.34,98.52-116.95A63.9,63.9,0,0,0,487.93,1569.58Zm411.22-165c79.38,42,182.83,26,257.08-19.47,57.23-35.08,102.26-90.52,124.17-154,18.15-52.59,20.66-111.69.19-163.42s-65.6-94.68-120.07-106.06-116.27,12.69-143.43,61.25c-14.59,26.08-19,56.9-33.53,83a127.75,127.75,0,0,1-8.31,12.94c-19,26.14-47,45.23-73.48,64.5-26.85,19.57-58,42.55-71.3,74.21a104.38,104.38,0,0,0-5.78,18.21C812.86,1330.1,850.7,1379,899.15,1404.55ZM1920,816.64V2454a999.53,999.53,0,0,1-98.2,57.8c-33,17-68.74,33.18-105.89,48.19H1098.56c-57.6-60.58-63.7-138.86-61.23-231.63,3.74-140.29-26.89-204.32-132-294.41-76.6-65.63-187.94-130.47-187.4-245.09.53-114.8,121.34-190.75,232.78-218.24s234.9-32.71,324.61-104.33c160.09-127.82,126.45-390.86,257.41-548.41C1624.49,807.45,1778.85,780.59,1920,816.64ZM1778.65,964.19c-.1-29.59-39.07-37-61.3-26.52a47.59,47.59,0,0,0-24.75,28.16c-4,12.34-1.82,27.57,8.41,35.53,7.59,5.92,18,6.78,27.57,5.9,12.05-1.09,24.14-4.69,33.73-12.07S1778.7,976.3,1778.65,964.19ZM697.17,2282.84a28.82,28.82,0,0,0-13.39-9.51c-6.18-2-10.78-1.12-16.38,1.79a29.54,29.54,0,0,0-13.57,14.17c-3,6.91-3.19,15.19.34,21.86,3.72,7,11,11.55,18.52,14.24,8.24,3,18.08,3.89,25.22-1.18,8-5.67,9.15-15.7,6.94-25.12A42.9,42.9,0,0,0,697.17,2282.84Z"/>',
					'square'    => '<path fill-opacity=".2" d="M898.57,1666.48c2,8.4.93,17.35-6.19,22.41-6.37,4.53-15.15,3.69-22.51,1-6.7-2.4-13.21-6.42-16.53-12.71-3.15-5.94-3-13.34-.31-19.51a26.44,26.44,0,0,1,12.11-12.64c5-2.59,9.11-3.42,14.63-1.6a25.79,25.79,0,0,1,12,8.49A38.29,38.29,0,0,1,898.57,1666.48ZM1920,263.76V1920H1200.71c-34.85-54.31-40.33-119.19-40.28-193.51.11-136.19-31.88-199.19-138.37-289.41-77.58-65.73-189.57-131.58-192-242.92C827.67,1082.65,945.43,1012,1055.14,988.1s231.91-25.75,319-93c155.35-120.07,115.27-376.49,241-526.2,63.76-75.92,161.09-108.5,263.36-106.08C1892.19,262.46,1906.07,262.8,1920,263.76Zm-63.11,211.37c-.09-26.4-34.87-33-54.71-23.66a42.41,42.41,0,0,0-22.08,25.12c-3.54,11-1.63,24.61,7.5,31.72,6.78,5.28,16.05,6,24.61,5.26,10.75-1,21.54-4.19,30.09-10.78S1856.93,485.94,1856.89,475.13ZM743.33,1017c-15.07-39.89-59.55-57.94-100-54.77-60.35,4.72-137.07,80.22-103.28,147.2,12.66,25.09,38.29,41,65.08,45.67,66.44,11.57,154.72-39.07,142.58-121.22A81.7,81.7,0,0,0,743.33,1017ZM1072.74,886.5c73.25,41,168.12,26.51,235.94-16.62,52.27-33.23,93.17-86.15,112.78-147,16.24-50.39,18.07-107.16-1.16-157s-61-91.52-111.13-102.89-106.68,11.24-131.23,57.68c-13.18,25-16.94,54.53-30.11,79.48a121.81,121.81,0,0,1-7.94,12.95c-17,23.33-42,40.37-65.58,57.56-24,17.47-51.78,38-63.63,66.24a93.48,93.48,0,0,0-5.16,16.24C988.93,808.82,1025.5,860.08,1072.74,886.5Zm40.94,763.94c-4.69-43.19-25.19-87.38-54.23-116.94s-66.05-43.9-97.93-37.94c-24.92,4.65-48.16,25.23-48.2,58.32-.05,36.26,27.08,73.94,25.12,109.61-1.12,20.32-11.76,37.16-8.51,58.28,3.41,22.16,20.88,39.83,37.64,49.87,37.74,22.61,80.3,20.95,109.16-4.26s43.12-73.15,36.56-123Z"/>
									<path fill-opacity=".5" d="M1005.52,753.09a93.48,93.48,0,0,1,5.16-16.24c11.85-28.26,39.67-48.77,63.63-66.24,23.59-17.19,48.58-34.23,65.58-57.56a115.11,115.11,0,0,0,7.42-11.54c13-23.29,16.9-50.8,29.92-74.07,24.24-43.34,79.41-64.82,128-54.66s88.88,48.48,107.15,94.65,16,98.91-.16,145.85c-19.56,56.69-59.75,106.17-110.82,137.48-66.27,40.61-158.59,54.82-229.44,17.38C1028.73,845.29,995,801.69,1005.52,753.09ZM891.72,1652a25.79,25.79,0,0,0-12-8.49c-5.52-1.82-9.63-1-14.63,1.6A26.44,26.44,0,0,0,853,1657.72c-2.68,6.17-2.84,13.57.31,19.51,3.32,6.29,9.83,10.31,16.53,12.71,7.36,2.64,16.14,3.48,22.51-1,7.12-5.06,8.17-14,6.19-22.41A38.29,38.29,0,0,0,891.72,1652ZM1920,263.76V1920H1221.66c-34.85-54.31-40.33-119.19-40.28-193.51.11-136.19-31.88-199.19-138.37-289.41-77.58-65.73-189.57-131.58-192-242.92-2.42-111.51,115.34-182.21,225-206.06s231.91-25.75,319-93C1550.4,775,1510.32,518.58,1636,368.87c59.39-70.72,147.91-103.83,242.41-106.08C1892.19,262.46,1906.07,262.8,1920,263.76ZM1802.18,451.47a42.41,42.41,0,0,0-22.08,25.12c-3.54,11-1.63,24.61,7.5,31.72,6.78,5.28,16.05,6,24.61,5.26,10.75-1,21.54-4.19,30.09-10.78s14.63-16.85,14.59-27.66C1856.8,448.73,1822,442.15,1802.18,451.47ZM1109.32,1654.56c-5.14-40.27-24.09-81.86-50.15-110s-58.7-42.42-86.39-37.65c-21.63,3.73-41.42,22.31-40.67,53.08.83,33.72,25.42,69.42,24.57,102.55-.49,18.87-9.38,34.27-6,54,3.51,20.69,19.18,37.54,34.06,47.29,33.48,21.93,70.59,21.41,95.17-1.34s35.88-67,29-113.49Zm-391-645.38c-20.72-28.67-63.45-35.38-98.71-26.18C567,996.72,513,1068.47,555.34,1115.2c15.85,17.51,41.48,25.68,66.07,24.88,61-2,129.78-56.24,103.85-118.42A62.07,62.07,0,0,0,718.3,1009.18Z"/>
									<path d="M1637.39,433.81c-116.87,140.61-86.85,375.36-229.73,489.44-80.06,63.91-190.24,68.56-289.69,93.1s-207.28,92.32-207.75,194.77c-.48,102.29,98.88,160.16,167.25,218.74,93.83,80.4,121.16,137.54,117.83,262.74-2.5,93.78,4.83,171,77.62,227.4h473.39c52.68-18.66,103.72-40.36,149.09-63.68q12.42-6.39,24.6-13.14v-1511C1813.11,321.22,1705.78,351.52,1637.39,433.81Zm204.91,69c-8.55,6.59-19.34,9.8-30.09,10.78-8.56.78-17.83,0-24.61-5.26-9.13-7.11-11-20.7-7.5-31.72a42.41,42.41,0,0,1,22.08-25.12c19.84-9.32,54.62-2.74,54.71,23.66C1856.93,485.94,1850.86,496.21,1842.3,502.79Zm-836.78,250.3a93.48,93.48,0,0,1,5.16-16.24c11.85-28.26,39.67-48.77,63.63-66.24,23.59-17.19,48.58-34.23,65.58-57.56a115.11,115.11,0,0,0,7.42-11.54c13-23.29,16.9-50.8,29.92-74.07,24.24-43.34,79.41-64.82,128-54.66s88.88,48.48,107.15,94.65,16,98.91-.16,145.85c-19.56,56.69-59.75,106.17-110.82,137.48-66.27,40.61-158.59,54.82-229.44,17.38C1028.73,845.29,995,801.69,1005.52,753.09Zm-294.9,273.56c20.81,55.88-37.14,103.41-87.92,104.38-20.48.39-41.72-7.25-54.7-23.1-34.63-42.3,11.2-105.66,55.13-117.21,29.47-7.75,65-1.18,81.84,24.7A56.48,56.48,0,0,1,710.62,1026.65Zm188,639.83c2,8.4.93,17.35-6.19,22.41-6.37,4.53-15.15,3.69-22.51,1-6.7-2.4-13.21-6.42-16.53-12.71-3.15-5.94-3-13.34-.31-19.51a26.44,26.44,0,0,1,12.11-12.64c5-2.59,9.11-3.42,14.63-1.6a25.79,25.79,0,0,1,12,8.49A38.29,38.29,0,0,1,898.57,1666.48Zm197.22-19.54c6.5,40.17-2.7,78.53-23.59,98.4s-52.81,20.61-81.88,1.9c-12.91-8.32-26.6-22.77-29.86-40.64-3.11-17,4.36-30.42,4.56-46.75.34-28.67-21.24-59.35-22.35-88.52-1-26.61,15.8-42.83,34.38-46.23,23.76-4.34,52,7.71,74.78,31.89s39.55,60,44.44,94.81Z"/>',
				),
				'rotated'          => array(
					'landscape' => '<path fill-opacity=".2" d="M508.31,132.4c-7.11,9.13-20.7,11-31.72,7.5a42.41,42.41,0,0,1-25.12-22.08C442.15,98,448.73,63.2,475.13,63.11c10.81,0,21.08,6,27.66,14.59s9.8,19.34,10.78,30.09C514.35,116.35,513.59,125.62,508.31,132.4ZM0,0H332.19c-11,106.89,19.33,214.22,101.62,282.61,140.61,116.87,375.36,86.85,489.44,229.73,63.91,80.06,68.56,190.24,93.1,289.69s92.32,207.28,194.77,207.75c102.29.48,160.16-98.88,218.74-167.25,80.4-93.83,137.54-121.16,262.74-117.83,93.78,2.5,171-4.83,227.4-77.62V1440H0ZM753.09,914.48c48.6,10.55,92.2-23.21,115-66.45,37.44-70.85,23.23-163.17-17.38-229.44C819.45,567.52,770,527.33,713.28,507.77c-46.94-16.2-99.69-18.44-145.85-.16s-84.5,58.55-94.65,107.15,11.32,103.77,54.66,128c23.27,13,50.78,16.91,74.07,29.92a115.11,115.11,0,0,1,11.54,7.42c23.33,17,40.37,42,57.56,65.58,17.47,24,38,51.78,66.24,63.63A93.48,93.48,0,0,0,753.09,914.48Zm273.56,294.9a56.48,56.48,0,0,0-11.23,5.65c-25.88,16.88-32.45,52.37-24.7,81.84,11.55,43.93,74.91,89.76,117.21,55.13,15.85-13,23.49-34.22,23.1-54.7C1130.06,1246.52,1082.53,1188.57,1026.65,1209.38Zm639.83-188a38.29,38.29,0,0,0-14.51,6.85,25.79,25.79,0,0,0-8.49,12c-1.82,5.52-1,9.63,1.6,14.63a26.44,26.44,0,0,0,12.64,12.11c6.17,2.68,13.57,2.84,19.51-.31,6.29-3.32,10.31-9.83,12.71-16.53,2.64-7.36,3.48-16.14-1-22.51C1683.83,1020.5,1674.88,1019.45,1666.48,1021.43Zm-19.54-197.22,4.86-.48c-34.8,4.89-70.63,21.69-94.81,44.44s-36.23,51-31.89,74.78c3.4,18.58,19.62,35.39,46.23,34.38,29.17-1.11,59.85-22.69,88.52-22.35,16.33.2,29.71,7.67,46.75,4.56,17.87-3.26,32.32-16.95,40.64-29.86,18.71-29.07,18-61-1.9-81.88S1687.11,817.71,1646.94,824.21ZM1920,173.69V0h-76.82q6.75,12.18,13.14,24.6C1879.64,70,1901.34,121,1920,173.69Z"/>
									<path fill-opacity=".5" d="M475.13,63.11c10.81,0,21.08,6,27.66,14.59s9.8,19.34,10.78,30.09c.78,8.56,0,17.83-5.26,24.61-7.11,9.13-20.7,11-31.72,7.5a42.41,42.41,0,0,1-25.12-22.08C442.15,98,448.73,63.2,475.13,63.11ZM0,0H263.76c-1,13.93-1.3,27.81-1,41.56,2.25,94.5,35.36,183,106.08,242.41C518.58,409.68,775,369.6,895.07,525c67.28,87,69.18,209.24,93,319s94.55,227.47,206.06,225.05c111.34-2.4,177.19-114.39,242.92-192,90.22-106.49,153.22-138.48,289.41-138.37,74.32,0,139.2-5.43,193.51-40.28V1440H0ZM1559.94,987.89c33.72-.83,69.42-25.42,102.55-24.57,18.87.49,34.27,9.38,54,6,20.69-3.51,37.54-19.18,47.29-34.06,21.93-33.48,21.41-70.59-1.34-95.17s-67-35.88-113.49-29l5.62-.48c-40.27,5.14-81.86,24.09-110,50.15s-42.42,58.7-37.65,86.39C1510.59,968.85,1529.17,988.64,1559.94,987.89Zm-538.28,206.85a62.07,62.07,0,0,0-12.48,7c-28.67,20.72-35.38,63.45-26.18,98.71,13.72,52.57,85.47,106.55,132.2,64.25,17.51-15.85,25.68-41.48,24.88-66.07C1138.08,1237.62,1083.84,1168.81,1021.66,1194.74Zm655.57-128.08c6.29-3.32,10.31-9.83,12.71-16.53,2.64-7.36,3.48-16.14-1-22.51-5.06-7.12-14-8.17-22.41-6.19a38.29,38.29,0,0,0-14.51,6.85,25.79,25.79,0,0,0-8.49,12c-1.82,5.52-1,9.63,1.6,14.63a26.44,26.44,0,0,0,12.64,12.11C1663.89,1069.65,1671.29,1069.81,1677.23,1066.66Zm-1111.4-567c-49.88,19.23-91.52,61-102.89,111.13s11.24,106.68,57.68,131.23c25,13.18,54.53,16.94,79.48,30.11a121.81,121.81,0,0,1,12.95,7.94c23.33,17,40.37,42,57.56,65.58,17.47,24,38,51.78,66.24,63.63a93.48,93.48,0,0,0,16.24,5.16c55.73,16.59,107-20,133.41-67.22,41-73.25,26.51-168.12-16.62-235.94-33.23-52.27-86.15-93.17-147-112.78C672.48,482.3,615.71,480.47,565.83,499.7Z"/>
									<path d="M475.13,63.11c10.81,0,21.08,6,27.66,14.59s9.8,19.34,10.78,30.09c.78,8.56,0,17.83-5.26,24.61-7.11,9.13-20.7,11-31.72,7.5a42.41,42.41,0,0,1-25.12-22.08C442.15,98,448.73,63.2,475.13,63.11ZM1726.49,759.57c74.32,0,139.2-5.43,193.51-40.28V1440H0V0H263.76c-1,13.93-1.3,27.81-1,41.56C260.37,143.83,293,241.16,368.87,304.92c149.71,125.71,406.13,85.63,526.2,241,67.28,87.05,69.18,209.24,93,319s94.55,227.47,206.06,225.05c111.34-2.4,177.19-114.39,242.92-192C1527.3,791.45,1590.3,759.46,1726.49,759.57Zm-840,87.69c41-73.25,26.51-168.12-16.62-235.94-33.23-52.27-86.15-93.17-147-112.78-50.39-16.24-107.16-18.07-157,1.16s-91.52,61-102.89,111.13,11.24,106.68,57.68,131.23c25,13.18,54.53,16.94,79.48,30.11a121.81,121.81,0,0,1,12.95,7.94c23.33,17,40.37,42,57.56,65.58,17.47,24,38,51.78,66.24,63.63a93.48,93.48,0,0,0,16.24,5.16C808.82,931.07,860.08,894.5,886.5,847.26Zm147.36,325.07a81.7,81.7,0,0,0-16.88,4.34c-39.89,15.07-57.94,59.55-54.77,100,4.72,60.35,80.22,137.07,147.2,103.28,25.09-12.66,41-38.29,45.67-65.08C1166.65,1248.47,1116,1160.19,1033.86,1172.33Zm632.62-150.9a38.29,38.29,0,0,0-14.51,6.85,25.79,25.79,0,0,0-8.49,12c-1.82,5.52-1,9.63,1.6,14.63a26.44,26.44,0,0,0,12.64,12.11c6.17,2.68,13.57,2.84,19.51-.31,6.29-3.32,10.31-9.83,12.71-16.53,2.64-7.36,3.48-16.14-1-22.51C1683.83,1020.5,1674.88,1019.45,1666.48,1021.43ZM1644.4,806.71l6-.39c-43.19,4.69-87.38,25.19-116.94,54.23s-43.9,66.05-37.94,97.93c4.65,24.92,25.23,48.16,58.32,48.2,36.26.05,73.94-27.08,109.61-25.12,20.32,1.12,37.15,11.76,58.28,8.51,22.16-3.41,39.83-20.88,49.87-37.64,22.61-37.74,20.95-80.3-4.26-109.16S1694.23,800.15,1644.4,806.71Z"/>',
					'portrait'  => '<path fill-opacity=".2" d="M508.31,132.4c-7.11,9.13-20.7,11-31.72,7.5a42.41,42.41,0,0,1-25.12-22.08C442.15,98,448.73,63.2,475.13,63.11c10.81,0,21.08,6,27.66,14.59s9.8,19.34,10.78,30.09C514.35,116.35,513.59,125.62,508.31,132.4ZM0,0H332.19c-11,106.89,19.33,214.22,101.62,282.61,140.61,116.87,375.36,86.85,489.44,229.73,63.91,80.06,68.56,190.24,93.1,289.69s92.32,207.28,194.77,207.75c102.29.48,160.16-98.88,218.74-167.25,80.4-93.83,137.54-121.16,262.74-117.83,93.78,2.5,171-4.83,227.4-77.62V2560H0ZM753.09,914.48c48.6,10.55,92.2-23.21,115-66.45,37.44-70.85,23.23-163.17-17.38-229.44C819.45,567.52,770,527.33,713.28,507.77c-46.94-16.2-99.69-18.44-145.85-.16s-84.5,58.55-94.65,107.15,11.32,103.77,54.66,128c23.27,13,50.78,16.91,74.07,29.92a115.11,115.11,0,0,1,11.54,7.42c23.33,17,40.37,42,57.56,65.58,17.47,24,38,51.78,66.24,63.63A93.48,93.48,0,0,0,753.09,914.48Zm273.56,294.9a56.48,56.48,0,0,0-11.23,5.65c-25.88,16.88-32.45,52.37-24.7,81.84,11.55,43.93,74.91,89.76,117.21,55.13,15.85-13,23.49-34.22,23.1-54.7C1130.06,1246.52,1082.53,1188.57,1026.65,1209.38Zm639.83-188a38.29,38.29,0,0,0-14.51,6.85,25.79,25.79,0,0,0-8.49,12c-1.82,5.52-1,9.63,1.6,14.63a26.44,26.44,0,0,0,12.64,12.11c6.17,2.68,13.57,2.84,19.51-.31,6.29-3.32,10.31-9.83,12.71-16.53,2.64-7.36,3.48-16.14-1-22.51C1683.83,1020.5,1674.88,1019.45,1666.48,1021.43Zm-19.54-197.22,4.86-.48c-34.8,4.89-70.63,21.69-94.81,44.44s-36.23,51-31.89,74.78c3.4,18.58,19.62,35.39,46.23,34.38,29.17-1.11,59.85-22.69,88.52-22.35,16.33.2,29.71,7.67,46.75,4.56,17.87-3.26,32.32-16.95,40.64-29.86,18.71-29.07,18-61-1.9-81.88S1687.11,817.71,1646.94,824.21ZM1920,173.69V0h-76.82q6.75,12.18,13.14,24.6C1879.64,70,1901.34,121,1920,173.69Z"/>
									<path fill-opacity=".5" d="M475.13,63.11c10.81,0,21.08,6,27.66,14.59s9.8,19.34,10.78,30.09c.78,8.56,0,17.83-5.26,24.61-7.11,9.13-20.7,11-31.72,7.5a42.41,42.41,0,0,1-25.12-22.08C442.15,98,448.73,63.2,475.13,63.11ZM0,0H263.76c-1,13.93-1.3,27.81-1,41.56,2.25,94.5,35.36,183,106.08,242.41C518.58,409.68,775,369.6,895.07,525c67.28,87,69.18,209.24,93,319s94.55,227.47,206.06,225.05c111.34-2.4,177.19-114.39,242.92-192,90.22-106.49,153.22-138.48,289.41-138.37,74.32,0,139.2-5.43,193.51-40.28V2560H0ZM1559.94,987.89c33.72-.83,69.42-25.42,102.55-24.57,18.87.49,34.27,9.38,54,6,20.69-3.51,37.54-19.18,47.29-34.06,21.93-33.48,21.41-70.59-1.34-95.17s-67-35.88-113.49-29l5.62-.48c-40.27,5.14-81.86,24.09-110,50.15s-42.42,58.7-37.65,86.39C1510.59,968.85,1529.17,988.64,1559.94,987.89Zm-538.28,206.85a62.07,62.07,0,0,0-12.48,7c-28.67,20.72-35.38,63.45-26.18,98.71,13.72,52.57,85.47,106.55,132.2,64.25,17.51-15.85,25.68-41.48,24.88-66.07C1138.08,1237.62,1083.84,1168.81,1021.66,1194.74Zm655.57-128.08c6.29-3.32,10.31-9.83,12.71-16.53,2.64-7.36,3.48-16.14-1-22.51-5.06-7.12-14-8.17-22.41-6.19a38.29,38.29,0,0,0-14.51,6.85,25.79,25.79,0,0,0-8.49,12c-1.82,5.52-1,9.63,1.6,14.63a26.44,26.44,0,0,0,12.64,12.11C1663.89,1069.65,1671.29,1069.81,1677.23,1066.66Zm-1111.4-567c-49.88,19.23-91.52,61-102.89,111.13s11.24,106.68,57.68,131.23c25,13.18,54.53,16.94,79.48,30.11a121.81,121.81,0,0,1,12.95,7.94c23.33,17,40.37,42,57.56,65.58,17.47,24,38,51.78,66.24,63.63a93.48,93.48,0,0,0,16.24,5.16c55.73,16.59,107-20,133.41-67.22,41-73.25,26.51-168.12-16.62-235.94-33.23-52.27-86.15-93.17-147-112.78C672.48,482.3,615.71,480.47,565.83,499.7Z"/>
									<path d="M475.13,63.11c10.81,0,21.08,6,27.66,14.59s9.8,19.34,10.78,30.09c.78,8.56,0,17.83-5.26,24.61-7.11,9.13-20.7,11-31.72,7.5a42.41,42.41,0,0,1-25.12-22.08C442.15,98,448.73,63.2,475.13,63.11ZM1726.49,759.57c74.32,0,139.2-5.43,193.51-40.28V2560H0V0H263.76c-1,13.93-1.3,27.81-1,41.56C260.37,143.83,293,241.16,368.87,304.92c149.71,125.71,406.13,85.63,526.2,241,67.28,87.05,69.18,209.24,93,319s94.55,227.47,206.06,225.05c111.34-2.4,177.19-114.39,242.92-192C1527.3,791.45,1590.3,759.46,1726.49,759.57Zm-840,87.69c41-73.25,26.51-168.12-16.62-235.94-33.23-52.27-86.15-93.17-147-112.78-50.39-16.24-107.16-18.07-157,1.16s-91.52,61-102.89,111.13,11.24,106.68,57.68,131.23c25,13.18,54.53,16.94,79.48,30.11a121.81,121.81,0,0,1,12.95,7.94c23.33,17,40.37,42,57.56,65.58,17.47,24,38,51.78,66.24,63.63a93.48,93.48,0,0,0,16.24,5.16C808.82,931.07,860.08,894.5,886.5,847.26Zm147.36,325.07a81.7,81.7,0,0,0-16.88,4.34c-39.89,15.07-57.94,59.55-54.77,100,4.72,60.35,80.22,137.07,147.2,103.28,25.09-12.66,41-38.29,45.67-65.08C1166.65,1248.47,1116,1160.19,1033.86,1172.33Zm632.62-150.9a38.29,38.29,0,0,0-14.51,6.85,25.79,25.79,0,0,0-8.49,12c-1.82,5.52-1,9.63,1.6,14.63a26.44,26.44,0,0,0,12.64,12.11c6.17,2.68,13.57,2.84,19.51-.31,6.29-3.32,10.31-9.83,12.71-16.53,2.64-7.36,3.48-16.14-1-22.51C1683.83,1020.5,1674.88,1019.45,1666.48,1021.43ZM1644.4,806.71l6-.39c-43.19,4.69-87.38,25.19-116.94,54.23s-43.9,66.05-37.94,97.93c4.65,24.92,25.23,48.16,58.32,48.2,36.26.05,73.94-27.08,109.61-25.12,20.32,1.12,37.15,11.76,58.28,8.51,22.16-3.41,39.83-20.88,49.87-37.64,22.61-37.74,20.95-80.3-4.26-109.16S1694.23,800.15,1644.4,806.71Z"/>',
					'square'    => '<path fill-opacity=".2" d="M508.31,132.4c-7.11,9.13-20.7,11-31.72,7.5a42.41,42.41,0,0,1-25.12-22.08C442.15,98,448.73,63.2,475.13,63.11c10.81,0,21.08,6,27.66,14.59s9.8,19.34,10.78,30.09C514.35,116.35,513.59,125.62,508.31,132.4ZM0,0H332.19c-11,106.89,19.33,214.22,101.62,282.61,140.61,116.87,375.36,86.85,489.44,229.73,63.91,80.06,68.56,190.24,93.1,289.69s92.32,207.28,194.77,207.75c102.29.48,160.16-98.88,218.74-167.25,80.4-93.83,137.54-121.16,262.74-117.83,93.78,2.5,171-4.83,227.4-77.62V1920H0ZM753.09,914.48c48.6,10.55,92.2-23.21,115-66.45,37.44-70.85,23.23-163.17-17.38-229.44C819.45,567.52,770,527.33,713.28,507.77c-46.94-16.2-99.69-18.44-145.85-.16s-84.5,58.55-94.65,107.15,11.32,103.77,54.66,128c23.27,13,50.78,16.91,74.07,29.92a115.11,115.11,0,0,1,11.54,7.42c23.33,17,40.37,42,57.56,65.58,17.47,24,38,51.78,66.24,63.63A93.48,93.48,0,0,0,753.09,914.48Zm273.56,294.9a56.48,56.48,0,0,0-11.23,5.65c-25.88,16.88-32.45,52.37-24.7,81.84,11.55,43.93,74.91,89.76,117.21,55.13,15.85-13,23.49-34.22,23.1-54.7C1130.06,1246.52,1082.53,1188.57,1026.65,1209.38Zm639.83-188a38.29,38.29,0,0,0-14.51,6.85,25.79,25.79,0,0,0-8.49,12c-1.82,5.52-1,9.63,1.6,14.63a26.44,26.44,0,0,0,12.64,12.11c6.17,2.68,13.57,2.84,19.51-.31,6.29-3.32,10.31-9.83,12.71-16.53,2.64-7.36,3.48-16.14-1-22.51C1683.83,1020.5,1674.88,1019.45,1666.48,1021.43Zm-19.54-197.22,4.86-.48c-34.8,4.89-70.63,21.69-94.81,44.44s-36.23,51-31.89,74.78c3.4,18.58,19.62,35.39,46.23,34.38,29.17-1.11,59.85-22.69,88.52-22.35,16.33.2,29.71,7.67,46.75,4.56,17.87-3.26,32.32-16.95,40.64-29.86,18.71-29.07,18-61-1.9-81.88S1687.11,817.71,1646.94,824.21ZM1920,173.69V0h-76.82q6.75,12.18,13.14,24.6C1879.64,70,1901.34,121,1920,173.69Z"/>
									<path fill-opacity=".5" d="M475.13,63.11c10.81,0,21.08,6,27.66,14.59s9.8,19.34,10.78,30.09c.78,8.56,0,17.83-5.26,24.61-7.11,9.13-20.7,11-31.72,7.5a42.41,42.41,0,0,1-25.12-22.08C442.15,98,448.73,63.2,475.13,63.11ZM0,0H263.76c-1,13.93-1.3,27.81-1,41.56,2.25,94.5,35.36,183,106.08,242.41C518.58,409.68,775,369.6,895.07,525c67.28,87,69.18,209.24,93,319s94.55,227.47,206.06,225.05c111.34-2.4,177.19-114.39,242.92-192,90.22-106.49,153.22-138.48,289.41-138.37,74.32,0,139.2-5.43,193.51-40.28V1920H0ZM1559.94,987.89c33.72-.83,69.42-25.42,102.55-24.57,18.87.49,34.27,9.38,54,6,20.69-3.51,37.54-19.18,47.29-34.06,21.93-33.48,21.41-70.59-1.34-95.17s-67-35.88-113.49-29l5.62-.48c-40.27,5.14-81.86,24.09-110,50.15s-42.42,58.7-37.65,86.39C1510.59,968.85,1529.17,988.64,1559.94,987.89Zm-538.28,206.85a62.07,62.07,0,0,0-12.48,7c-28.67,20.72-35.38,63.45-26.18,98.71,13.72,52.57,85.47,106.55,132.2,64.25,17.51-15.85,25.68-41.48,24.88-66.07C1138.08,1237.62,1083.84,1168.81,1021.66,1194.74Zm655.57-128.08c6.29-3.32,10.31-9.83,12.71-16.53,2.64-7.36,3.48-16.14-1-22.51-5.06-7.12-14-8.17-22.41-6.19a38.29,38.29,0,0,0-14.51,6.85,25.79,25.79,0,0,0-8.49,12c-1.82,5.52-1,9.63,1.6,14.63a26.44,26.44,0,0,0,12.64,12.11C1663.89,1069.65,1671.29,1069.81,1677.23,1066.66Zm-1111.4-567c-49.88,19.23-91.52,61-102.89,111.13s11.24,106.68,57.68,131.23c25,13.18,54.53,16.94,79.48,30.11a121.81,121.81,0,0,1,12.95,7.94c23.33,17,40.37,42,57.56,65.58,17.47,24,38,51.78,66.24,63.63a93.48,93.48,0,0,0,16.24,5.16c55.73,16.59,107-20,133.41-67.22,41-73.25,26.51-168.12-16.62-235.94-33.23-52.27-86.15-93.17-147-112.78C672.48,482.3,615.71,480.47,565.83,499.7Z"/>
									<path d="M475.13,63.11c10.81,0,21.08,6,27.66,14.59s9.8,19.34,10.78,30.09c.78,8.56,0,17.83-5.26,24.61-7.11,9.13-20.7,11-31.72,7.5a42.41,42.41,0,0,1-25.12-22.08C442.15,98,448.73,63.2,475.13,63.11ZM1726.49,759.57c74.32,0,139.2-5.43,193.51-40.28V1920H0V0H263.76c-1,13.93-1.3,27.81-1,41.56C260.37,143.83,293,241.16,368.87,304.92c149.71,125.71,406.13,85.63,526.2,241,67.28,87.05,69.18,209.24,93,319s94.55,227.47,206.06,225.05c111.34-2.4,177.19-114.39,242.92-192C1527.3,791.45,1590.3,759.46,1726.49,759.57Zm-840,87.69c41-73.25,26.51-168.12-16.62-235.94-33.23-52.27-86.15-93.17-147-112.78-50.39-16.24-107.16-18.07-157,1.16s-91.52,61-102.89,111.13,11.24,106.68,57.68,131.23c25,13.18,54.53,16.94,79.48,30.11a121.81,121.81,0,0,1,12.95,7.94c23.33,17,40.37,42,57.56,65.58,17.47,24,38,51.78,66.24,63.63a93.48,93.48,0,0,0,16.24,5.16C808.82,931.07,860.08,894.5,886.5,847.26Zm147.36,325.07a81.7,81.7,0,0,0-16.88,4.34c-39.89,15.07-57.94,59.55-54.77,100,4.72,60.35,80.22,137.07,147.2,103.28,25.09-12.66,41-38.29,45.67-65.08C1166.65,1248.47,1116,1160.19,1033.86,1172.33Zm632.62-150.9a38.29,38.29,0,0,0-14.51,6.85,25.79,25.79,0,0,0-8.49,12c-1.82,5.52-1,9.63,1.6,14.63a26.44,26.44,0,0,0,12.64,12.11c6.17,2.68,13.57,2.84,19.51-.31,6.29-3.32,10.31-9.83,12.71-16.53,2.64-7.36,3.48-16.14-1-22.51C1683.83,1020.5,1674.88,1019.45,1666.48,1021.43ZM1644.4,806.71l6-.39c-43.19,4.69-87.38,25.19-116.94,54.23s-43.9,66.05-37.94,97.93c4.65,24.92,25.23,48.16,58.32,48.2,36.26.05,73.94-27.08,109.61-25.12,20.32,1.12,37.15,11.76,58.28,8.51,22.16-3.41,39.83-20.88,49.87-37.64,22.61-37.74,20.95-80.3-4.26-109.16S1694.23,800.15,1644.4,806.71Z"/>',
				),
				'rotated-inverted' => array(
					'landscape' => '<path fill-opacity=".2" d="M1672.48,1021.43c8.4-2,17.35-.93,22.41,6.19,4.53,6.37,3.69,15.15,1,22.51-2.4,6.7-6.42,13.21-12.71,16.53-5.94,3.15-13.34,3-19.51.31a26.44,26.44,0,0,1-12.64-12.11c-2.59-5-3.42-9.11-1.6-14.63a25.79,25.79,0,0,1,8.49-12A38.29,38.29,0,0,1,1672.48,1021.43ZM269.76,0H1926V719.29c-54.31,34.85-119.19,40.33-193.51,40.28-136.19-.11-199.19,31.88-289.41,138.37-65.73,77.58-131.58,189.57-242.92,192C1088.65,1092.33,1018,974.57,994.1,864.86s-25.75-231.91-93-319C781,390.55,524.58,430.63,374.87,304.92,299,241.16,266.37,143.83,268.79,41.56,268.46,27.81,268.8,13.93,269.76,0ZM481.13,63.11c-26.4.09-33,34.87-23.66,54.71a42.41,42.41,0,0,0,25.12,22.08c11,3.54,24.61,1.63,31.72-7.5,5.28-6.78,6-16.05,5.26-24.61-1-10.75-4.19-21.54-10.78-30.09S491.94,63.07,481.13,63.11ZM1023,1176.67c-39.89,15.07-57.94,59.55-54.77,100,4.72,60.35,80.22,137.07,147.2,103.28,25.09-12.66,41-38.29,45.67-65.08,11.57-66.44-39.07-154.72-121.22-142.58A81.7,81.7,0,0,0,1023,1176.67ZM892.5,847.26c41-73.25,26.51-168.12-16.62-235.94-33.23-52.27-86.15-93.17-147-112.78-50.39-16.24-107.16-18.07-157,1.16s-91.52,61-102.89,111.13,11.24,106.68,57.68,131.23c25,13.18,54.53,16.94,79.48,30.11a121.81,121.81,0,0,1,12.95,7.94c23.33,17,40.37,42,57.56,65.58,17.47,24,38,51.78,66.24,63.63a93.48,93.48,0,0,0,16.24,5.16C814.82,931.07,866.08,894.5,892.5,847.26Zm763.94-40.94c-43.19,4.69-87.38,25.19-116.94,54.23s-43.9,66.05-37.94,97.93c4.65,24.92,25.23,48.16,58.32,48.2,36.26.05,73.94-27.08,109.61-25.12,20.32,1.12,37.16,11.76,58.28,8.51,22.16-3.41,39.83-20.88,49.87-37.64,22.61-37.74,20.95-80.3-4.26-109.16s-73.15-43.12-123-36.56Z"/>
									<path fill-opacity=".5" d="M759.09,914.48a93.48,93.48,0,0,1-16.24-5.16c-28.26-11.85-48.77-39.67-66.24-63.63-17.19-23.59-34.23-48.58-57.56-65.58a115.11,115.11,0,0,0-11.54-7.42c-23.29-13-50.8-16.9-74.07-29.92-43.34-24.24-64.82-79.41-54.66-128s48.48-88.88,94.65-107.15,98.91-16,145.85.16C776,527.33,825.45,567.52,856.76,618.59c40.61,66.27,54.82,158.59,17.38,229.44C851.29,891.27,807.69,925,759.09,914.48ZM1658,1028.28a25.79,25.79,0,0,0-8.49,12c-1.82,5.52-1,9.63,1.6,14.63a26.44,26.44,0,0,0,12.64,12.11c6.17,2.68,13.57,2.84,19.51-.31,6.29-3.32,10.31-9.83,12.71-16.53,2.64-7.36,3.48-16.14-1-22.51-5.06-7.12-14-8.17-22.41-6.19A38.29,38.29,0,0,0,1658,1028.28ZM269.76,0H1926V698.34c-54.31,34.85-119.19,40.33-193.51,40.28C1596.3,738.51,1533.3,770.5,1443.08,877c-65.73,77.58-131.58,189.57-242.92,192C1088.65,1071.38,1018,953.62,994.1,843.91s-25.75-231.91-93-319C781,369.6,524.58,409.68,374.87,284,304.15,224.58,271,136.06,268.79,41.56,268.46,27.81,268.8,13.93,269.76,0ZM457.47,117.82a42.41,42.41,0,0,0,25.12,22.08c11,3.54,24.61,1.63,31.72-7.5,5.28-6.78,6-16.05,5.26-24.61-1-10.75-4.19-21.54-10.78-30.09s-16.85-14.63-27.66-14.59C454.73,63.2,448.15,98,457.47,117.82ZM1660.56,810.68c-40.27,5.14-81.86,24.09-110,50.15s-42.42,58.7-37.65,86.39c3.73,21.63,22.31,41.42,53.08,40.67,33.72-.83,69.42-25.42,102.55-24.57,18.87.49,34.27,9.38,54,6,20.69-3.51,37.54-19.18,47.29-34.06,21.93-33.48,21.41-70.59-1.34-95.17s-67-35.88-113.49-29Zm-645.38,391c-28.67,20.72-35.38,63.45-26.18,98.71,13.72,52.57,85.47,106.55,132.2,64.25,17.51-15.85,25.68-41.48,24.88-66.07-2-61-56.24-129.78-118.42-103.85A62.07,62.07,0,0,0,1015.18,1201.7Z"/>
									<path d="M439.81,282.61c140.61,116.87,375.36,86.85,489.44,229.73,63.91,80.06,68.56,190.24,93.1,289.69s92.32,207.28,194.77,207.75c102.29.48,160.16-98.88,218.74-167.25,80.4-93.83,137.54-121.16,262.74-117.83,93.78,2.5,171-4.83,227.4-77.62V173.69C1907.34,121,1885.64,70,1862.32,24.6q-6.39-12.42-13.14-24.6h-1511C327.22,106.89,357.52,214.22,439.81,282.61Zm69-204.91c6.59,8.55,9.8,19.34,10.78,30.09.78,8.56,0,17.83-5.26,24.61-7.11,9.13-20.7,11-31.72,7.5a42.41,42.41,0,0,1-25.12-22.08C448.15,98,454.73,63.2,481.13,63.11,491.94,63.07,502.21,69.14,508.79,77.7Zm250.3,836.78a93.48,93.48,0,0,1-16.24-5.16c-28.26-11.85-48.77-39.67-66.24-63.63-17.19-23.59-34.23-48.58-57.56-65.58a115.11,115.11,0,0,0-11.54-7.42c-23.29-13-50.8-16.9-74.07-29.92-43.34-24.24-64.82-79.41-54.66-128s48.48-88.88,94.65-107.15,98.91-16,145.85.16C776,527.33,825.45,567.52,856.76,618.59c40.61,66.27,54.82,158.59,17.38,229.44C851.29,891.27,807.69,925,759.09,914.48Zm273.56,294.9c55.88-20.81,103.41,37.14,104.38,87.92.39,20.48-7.25,41.72-23.1,54.7-42.3,34.63-105.66-11.2-117.21-55.13-7.75-29.47-1.18-65,24.7-81.84A56.48,56.48,0,0,1,1032.65,1209.38Zm639.83-188c8.4-2,17.35-.93,22.41,6.19,4.53,6.37,3.69,15.15,1,22.51-2.4,6.7-6.42,13.21-12.71,16.53-5.94,3.15-13.34,3-19.51.31a26.44,26.44,0,0,1-12.64-12.11c-2.59-5-3.42-9.11-1.6-14.63a25.79,25.79,0,0,1,8.49-12A38.29,38.29,0,0,1,1672.48,1021.43Zm-19.54-197.22c40.17-6.5,78.53,2.7,98.4,23.59s20.61,52.81,1.9,81.88c-8.32,12.91-22.77,26.6-40.64,29.86-17,3.11-30.42-4.36-46.75-4.56-28.67-.34-59.35,21.24-88.52,22.35-26.61,1-42.83-15.8-46.23-34.38-4.34-23.76,7.71-52,31.89-74.78s60-39.55,94.81-44.44Z"/>',
					'portrait'  => '<path fill-opacity=".2" d="M1672.48,1021.43c8.4-2,17.35-.93,22.41,6.19,4.53,6.37,3.69,15.15,1,22.51-2.4,6.7-6.42,13.21-12.71,16.53-5.94,3.15-13.34,3-19.51.31a26.44,26.44,0,0,1-12.64-12.11c-2.59-5-3.42-9.11-1.6-14.63a25.79,25.79,0,0,1,8.49-12A38.29,38.29,0,0,1,1672.48,1021.43ZM269.76,0H1926V719.29c-54.31,34.85-119.19,40.33-193.51,40.28-136.19-.11-199.19,31.88-289.41,138.37-65.73,77.58-131.58,189.57-242.92,192C1088.65,1092.33,1018,974.57,994.1,864.86s-25.75-231.91-93-319C781,390.55,524.58,430.63,374.87,304.92,299,241.16,266.37,143.83,268.79,41.56,268.46,27.81,268.8,13.93,269.76,0ZM481.13,63.11c-26.4.09-33,34.87-23.66,54.71a42.41,42.41,0,0,0,25.12,22.08c11,3.54,24.61,1.63,31.72-7.5,5.28-6.78,6-16.05,5.26-24.61-1-10.75-4.19-21.54-10.78-30.09S491.94,63.07,481.13,63.11ZM1023,1176.67c-39.89,15.07-57.94,59.55-54.77,100,4.72,60.35,80.22,137.07,147.2,103.28,25.09-12.66,41-38.29,45.67-65.08,11.57-66.44-39.07-154.72-121.22-142.58A81.7,81.7,0,0,0,1023,1176.67ZM892.5,847.26c41-73.25,26.51-168.12-16.62-235.94-33.23-52.27-86.15-93.17-147-112.78-50.39-16.24-107.16-18.07-157,1.16s-91.52,61-102.89,111.13,11.24,106.68,57.68,131.23c25,13.18,54.53,16.94,79.48,30.11a121.81,121.81,0,0,1,12.95,7.94c23.33,17,40.37,42,57.56,65.58,17.47,24,38,51.78,66.24,63.63a93.48,93.48,0,0,0,16.24,5.16C814.82,931.07,866.08,894.5,892.5,847.26Zm763.94-40.94c-43.19,4.69-87.38,25.19-116.94,54.23s-43.9,66.05-37.94,97.93c4.65,24.92,25.23,48.16,58.32,48.2,36.26.05,73.94-27.08,109.61-25.12,20.32,1.12,37.16,11.76,58.28,8.51,22.16-3.41,39.83-20.88,49.87-37.64,22.61-37.74,20.95-80.3-4.26-109.16s-73.15-43.12-123-36.56Z"/>
									<path fill-opacity=".5" d="M759.09,914.48a93.48,93.48,0,0,1-16.24-5.16c-28.26-11.85-48.77-39.67-66.24-63.63-17.19-23.59-34.23-48.58-57.56-65.58a115.11,115.11,0,0,0-11.54-7.42c-23.29-13-50.8-16.9-74.07-29.92-43.34-24.24-64.82-79.41-54.66-128s48.48-88.88,94.65-107.15,98.91-16,145.85.16C776,527.33,825.45,567.52,856.76,618.59c40.61,66.27,54.82,158.59,17.38,229.44C851.29,891.27,807.69,925,759.09,914.48ZM1658,1028.28a25.79,25.79,0,0,0-8.49,12c-1.82,5.52-1,9.63,1.6,14.63a26.44,26.44,0,0,0,12.64,12.11c6.17,2.68,13.57,2.84,19.51-.31,6.29-3.32,10.31-9.83,12.71-16.53,2.64-7.36,3.48-16.14-1-22.51-5.06-7.12-14-8.17-22.41-6.19A38.29,38.29,0,0,0,1658,1028.28ZM269.76,0H1926V698.34c-54.31,34.85-119.19,40.33-193.51,40.28C1596.3,738.51,1533.3,770.5,1443.08,877c-65.73,77.58-131.58,189.57-242.92,192C1088.65,1071.38,1018,953.62,994.1,843.91s-25.75-231.91-93-319C781,369.6,524.58,409.68,374.87,284,304.15,224.58,271,136.06,268.79,41.56,268.46,27.81,268.8,13.93,269.76,0ZM457.47,117.82a42.41,42.41,0,0,0,25.12,22.08c11,3.54,24.61,1.63,31.72-7.5,5.28-6.78,6-16.05,5.26-24.61-1-10.75-4.19-21.54-10.78-30.09s-16.85-14.63-27.66-14.59C454.73,63.2,448.15,98,457.47,117.82ZM1660.56,810.68c-40.27,5.14-81.86,24.09-110,50.15s-42.42,58.7-37.65,86.39c3.73,21.63,22.31,41.42,53.08,40.67,33.72-.83,69.42-25.42,102.55-24.57,18.87.49,34.27,9.38,54,6,20.69-3.51,37.54-19.18,47.29-34.06,21.93-33.48,21.41-70.59-1.34-95.17s-67-35.88-113.49-29Zm-645.38,391c-28.67,20.72-35.38,63.45-26.18,98.71,13.72,52.57,85.47,106.55,132.2,64.25,17.51-15.85,25.68-41.48,24.88-66.07-2-61-56.24-129.78-118.42-103.85A62.07,62.07,0,0,0,1015.18,1201.7Z"/>
									<path d="M439.81,282.61c140.61,116.87,375.36,86.85,489.44,229.73,63.91,80.06,68.56,190.24,93.1,289.69s92.32,207.28,194.77,207.75c102.29.48,160.16-98.88,218.74-167.25,80.4-93.83,137.54-121.16,262.74-117.83,93.78,2.5,171-4.83,227.4-77.62V173.69C1907.34,121,1885.64,70,1862.32,24.6q-6.39-12.42-13.14-24.6h-1511C327.22,106.89,357.52,214.22,439.81,282.61Zm69-204.91c6.59,8.55,9.8,19.34,10.78,30.09.78,8.56,0,17.83-5.26,24.61-7.11,9.13-20.7,11-31.72,7.5a42.41,42.41,0,0,1-25.12-22.08C448.15,98,454.73,63.2,481.13,63.11,491.94,63.07,502.21,69.14,508.79,77.7Zm250.3,836.78a93.48,93.48,0,0,1-16.24-5.16c-28.26-11.85-48.77-39.67-66.24-63.63-17.19-23.59-34.23-48.58-57.56-65.58a115.11,115.11,0,0,0-11.54-7.42c-23.29-13-50.8-16.9-74.07-29.92-43.34-24.24-64.82-79.41-54.66-128s48.48-88.88,94.65-107.15,98.91-16,145.85.16C776,527.33,825.45,567.52,856.76,618.59c40.61,66.27,54.82,158.59,17.38,229.44C851.29,891.27,807.69,925,759.09,914.48Zm273.56,294.9c55.88-20.81,103.41,37.14,104.38,87.92.39,20.48-7.25,41.72-23.1,54.7-42.3,34.63-105.66-11.2-117.21-55.13-7.75-29.47-1.18-65,24.7-81.84A56.48,56.48,0,0,1,1032.65,1209.38Zm639.83-188c8.4-2,17.35-.93,22.41,6.19,4.53,6.37,3.69,15.15,1,22.51-2.4,6.7-6.42,13.21-12.71,16.53-5.94,3.15-13.34,3-19.51.31a26.44,26.44,0,0,1-12.64-12.11c-2.59-5-3.42-9.11-1.6-14.63a25.79,25.79,0,0,1,8.49-12A38.29,38.29,0,0,1,1672.48,1021.43Zm-19.54-197.22c40.17-6.5,78.53,2.7,98.4,23.59s20.61,52.81,1.9,81.88c-8.32,12.91-22.77,26.6-40.64,29.86-17,3.11-30.42-4.36-46.75-4.56-28.67-.34-59.35,21.24-88.52,22.35-26.61,1-42.83-15.8-46.23-34.38-4.34-23.76,7.71-52,31.89-74.78s60-39.55,94.81-44.44Z"/>',
					'square'    => '<path fill-opacity=".2" d="M1672.48,1021.43c8.4-2,17.35-.93,22.41,6.19,4.53,6.37,3.69,15.15,1,22.51-2.4,6.7-6.42,13.21-12.71,16.53-5.94,3.15-13.34,3-19.51.31a26.44,26.44,0,0,1-12.64-12.11c-2.59-5-3.42-9.11-1.6-14.63a25.79,25.79,0,0,1,8.49-12A38.29,38.29,0,0,1,1672.48,1021.43ZM269.76,0H1926V719.29c-54.31,34.85-119.19,40.33-193.51,40.28-136.19-.11-199.19,31.88-289.41,138.37-65.73,77.58-131.58,189.57-242.92,192C1088.65,1092.33,1018,974.57,994.1,864.86s-25.75-231.91-93-319C781,390.55,524.58,430.63,374.87,304.92,299,241.16,266.37,143.83,268.79,41.56,268.46,27.81,268.8,13.93,269.76,0ZM481.13,63.11c-26.4.09-33,34.87-23.66,54.71a42.41,42.41,0,0,0,25.12,22.08c11,3.54,24.61,1.63,31.72-7.5,5.28-6.78,6-16.05,5.26-24.61-1-10.75-4.19-21.54-10.78-30.09S491.94,63.07,481.13,63.11ZM1023,1176.67c-39.89,15.07-57.94,59.55-54.77,100,4.72,60.35,80.22,137.07,147.2,103.28,25.09-12.66,41-38.29,45.67-65.08,11.57-66.44-39.07-154.72-121.22-142.58A81.7,81.7,0,0,0,1023,1176.67ZM892.5,847.26c41-73.25,26.51-168.12-16.62-235.94-33.23-52.27-86.15-93.17-147-112.78-50.39-16.24-107.16-18.07-157,1.16s-91.52,61-102.89,111.13,11.24,106.68,57.68,131.23c25,13.18,54.53,16.94,79.48,30.11a121.81,121.81,0,0,1,12.95,7.94c23.33,17,40.37,42,57.56,65.58,17.47,24,38,51.78,66.24,63.63a93.48,93.48,0,0,0,16.24,5.16C814.82,931.07,866.08,894.5,892.5,847.26Zm763.94-40.94c-43.19,4.69-87.38,25.19-116.94,54.23s-43.9,66.05-37.94,97.93c4.65,24.92,25.23,48.16,58.32,48.2,36.26.05,73.94-27.08,109.61-25.12,20.32,1.12,37.16,11.76,58.28,8.51,22.16-3.41,39.83-20.88,49.87-37.64,22.61-37.74,20.95-80.3-4.26-109.16s-73.15-43.12-123-36.56Z"/>
									<path fill-opacity=".5" d="M759.09,914.48a93.48,93.48,0,0,1-16.24-5.16c-28.26-11.85-48.77-39.67-66.24-63.63-17.19-23.59-34.23-48.58-57.56-65.58a115.11,115.11,0,0,0-11.54-7.42c-23.29-13-50.8-16.9-74.07-29.92-43.34-24.24-64.82-79.41-54.66-128s48.48-88.88,94.65-107.15,98.91-16,145.85.16C776,527.33,825.45,567.52,856.76,618.59c40.61,66.27,54.82,158.59,17.38,229.44C851.29,891.27,807.69,925,759.09,914.48ZM1658,1028.28a25.79,25.79,0,0,0-8.49,12c-1.82,5.52-1,9.63,1.6,14.63a26.44,26.44,0,0,0,12.64,12.11c6.17,2.68,13.57,2.84,19.51-.31,6.29-3.32,10.31-9.83,12.71-16.53,2.64-7.36,3.48-16.14-1-22.51-5.06-7.12-14-8.17-22.41-6.19A38.29,38.29,0,0,0,1658,1028.28ZM269.76,0H1926V698.34c-54.31,34.85-119.19,40.33-193.51,40.28C1596.3,738.51,1533.3,770.5,1443.08,877c-65.73,77.58-131.58,189.57-242.92,192C1088.65,1071.38,1018,953.62,994.1,843.91s-25.75-231.91-93-319C781,369.6,524.58,409.68,374.87,284,304.15,224.58,271,136.06,268.79,41.56,268.46,27.81,268.8,13.93,269.76,0ZM457.47,117.82a42.41,42.41,0,0,0,25.12,22.08c11,3.54,24.61,1.63,31.72-7.5,5.28-6.78,6-16.05,5.26-24.61-1-10.75-4.19-21.54-10.78-30.09s-16.85-14.63-27.66-14.59C454.73,63.2,448.15,98,457.47,117.82ZM1660.56,810.68c-40.27,5.14-81.86,24.09-110,50.15s-42.42,58.7-37.65,86.39c3.73,21.63,22.31,41.42,53.08,40.67,33.72-.83,69.42-25.42,102.55-24.57,18.87.49,34.27,9.38,54,6,20.69-3.51,37.54-19.18,47.29-34.06,21.93-33.48,21.41-70.59-1.34-95.17s-67-35.88-113.49-29Zm-645.38,391c-28.67,20.72-35.38,63.45-26.18,98.71,13.72,52.57,85.47,106.55,132.2,64.25,17.51-15.85,25.68-41.48,24.88-66.07-2-61-56.24-129.78-118.42-103.85A62.07,62.07,0,0,0,1015.18,1201.7Z"/>
									<path d="M439.81,282.61c140.61,116.87,375.36,86.85,489.44,229.73,63.91,80.06,68.56,190.24,93.1,289.69s92.32,207.28,194.77,207.75c102.29.48,160.16-98.88,218.74-167.25,80.4-93.83,137.54-121.16,262.74-117.83,93.78,2.5,171-4.83,227.4-77.62V173.69C1907.34,121,1885.64,70,1862.32,24.6q-6.39-12.42-13.14-24.6h-1511C327.22,106.89,357.52,214.22,439.81,282.61Zm69-204.91c6.59,8.55,9.8,19.34,10.78,30.09.78,8.56,0,17.83-5.26,24.61-7.11,9.13-20.7,11-31.72,7.5a42.41,42.41,0,0,1-25.12-22.08C448.15,98,454.73,63.2,481.13,63.11,491.94,63.07,502.21,69.14,508.79,77.7Zm250.3,836.78a93.48,93.48,0,0,1-16.24-5.16c-28.26-11.85-48.77-39.67-66.24-63.63-17.19-23.59-34.23-48.58-57.56-65.58a115.11,115.11,0,0,0-11.54-7.42c-23.29-13-50.8-16.9-74.07-29.92-43.34-24.24-64.82-79.41-54.66-128s48.48-88.88,94.65-107.15,98.91-16,145.85.16C776,527.33,825.45,567.52,856.76,618.59c40.61,66.27,54.82,158.59,17.38,229.44C851.29,891.27,807.69,925,759.09,914.48Zm273.56,294.9c55.88-20.81,103.41,37.14,104.38,87.92.39,20.48-7.25,41.72-23.1,54.7-42.3,34.63-105.66-11.2-117.21-55.13-7.75-29.47-1.18-65,24.7-81.84A56.48,56.48,0,0,1,1032.65,1209.38Zm639.83-188c8.4-2,17.35-.93,22.41,6.19,4.53,6.37,3.69,15.15,1,22.51-2.4,6.7-6.42,13.21-12.71,16.53-5.94,3.15-13.34,3-19.51.31a26.44,26.44,0,0,1-12.64-12.11c-2.59-5-3.42-9.11-1.6-14.63a25.79,25.79,0,0,1,8.49-12A38.29,38.29,0,0,1,1672.48,1021.43Zm-19.54-197.22c40.17-6.5,78.53,2.7,98.4,23.59s20.61,52.81,1.9,81.88c-8.32,12.91-22.77,26.6-40.64,29.86-17,3.11-30.42-4.36-46.75-4.56-28.67-.34-59.35,21.24-88.52,22.35-26.61,1-42.83-15.8-46.23-34.38-4.34-23.76,7.71-52,31.89-74.78s60-39.55,94.81-44.44Z"/>',
				),
			),
		);
	}
}

return new ET_Builder_Mask_Layer_Blob();
