<?php
/**
 * Background Mask Style - Corner Blob.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Mask_Corner_Blob
 *
 * @since 4.15.0
 */
class ET_Builder_Mask_Corner_Blob extends ET_Builder_Background_Mask_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Corner Blob', 'et-builder' ),
			'svgContent' => array(
				'default'          => array(
					'landscape' => '<path d="M1226.07,328.74c94-75.59,257.39,3.9,344.21-18.37,83.76-21.48,100.79-166,263.41-157.59,34.24,1.76,61.43,23.87,86.31,52.4V0H0V1440H1091.59c-52-65.69-165.68-107.33-188.19-187.31-8.34-29.63-5.63-52.8,1.35-74.62-5.56-51,24.41-80.39,39.63-129.07,2.91-86.63-76.42-153.71-33.64-221a79,79,0,0,1,11.18-15.4,78.9,78.9,0,0,1,6.22-10.79C970,732.76,1083.24,783.57,1159.21,677c.49-.69,1-1.4,1.43-2.12C1196.21,595.86,1126.27,409,1226.07,328.74Z"/>
									<path fill-opacity=".3" d="M952.1,1009.94a181.86,181.86,0,0,1-7.72,39.06c2.91-86.63-76.42-153.71-33.64-221a79,79,0,0,1,11.18-15.4C894.22,871,958.69,933.43,952.1,1009.94Zm130,373.3c-42.44-67.36-155.14-109.94-174.26-188.12a133.1,133.1,0,0,1-3-17c-7,21.82-9.69,45-1.35,74.62,22.51,80,136.18,121.62,188.19,187.31h13.8C1099.67,1419.33,1092.54,1399.87,1082.06,1383.24ZM1833.69,152.78C1671.07,144.4,1654,288.89,1570.28,310.37c-86.82,22.27-250.21-57.22-344.21,18.37-99.8,80.25-29.86,267.12-65.43,346.17,43.61-67.06-22.65-252.08,75.63-325.68,89.51-67,238.38,11.83,319.54-6,78.31-17.24,98.7-150.58,249.12-137.63,49.87,4.29,81.92,54.75,115.07,101.64v-102C1895.12,176.65,1867.93,154.54,1833.69,152.78Z"/>',
					'portrait'  => '<path d="M1072.44,992.64c121.91-98,333.81,5.06,446.41-23.82C1627.5,941,1649.58,753.56,1860.49,764.43c21.8,1.12,41.39,8.6,59.51,20.3V0H0V2560H945.81c-6.7-23.62-11.88-48.5-17.25-73.2a237.7,237.7,0,0,0-21.95-41.23C844,2353.45,684.44,2299.35,653.94,2191c-10.81-38.44-7.3-68.49,1.76-96.79-7.21-66.08,31.66-104.26,51.39-167.39,3.78-112.37-99.12-199.36-43.63-286.59a102.92,102.92,0,0,1,14.5-20,101.63,101.63,0,0,1,8.07-14c54.28-89.61,201.16-23.71,299.68-161.88.64-.9,1.26-1.82,1.86-2.75C1033.7,1339.09,943,1096.72,1072.44,992.64Z"/>
									<path fill-opacity=".3" d="M663.46,1640.21a102.92,102.92,0,0,1,14.5-20C642,1696,725.65,1776.91,717.1,1876.13a235.88,235.88,0,0,1-10,50.67C710.87,1814.43,608,1727.44,663.46,1640.21ZM653.94,2191c30.5,108.37,190.1,162.47,252.67,254.59a237.7,237.7,0,0,1,21.95,41.23c-10-45.87-20.61-91.12-42.91-126.51-55-87.37-201.2-142.58-226-244a169.76,169.76,0,0,1-3.94-22.12C646.64,2122.49,643.13,2152.54,653.94,2191ZM1860.49,764.43c-210.91-10.87-233,176.52-341.64,204.39-112.6,28.88-324.5-74.21-446.41,23.82-129.45,104.08-38.74,346.45-84.87,449,56.57-87-29.37-326.94,98.09-422.41,116.1-87,309.17,15.34,414.43-7.83,101.57-22.35,128-195.29,323.1-178.5,38.83,3.34,69.33,28.26,96.81,60.81v-109C1901.88,773,1882.29,765.55,1860.49,764.43Z"/>',
					'square'    => '<path d="M1116.8,599.88c103.68-83.37,283.89,4.31,379.65-20.25,92.39-23.7,111.17-183.06,290.53-173.83,55.65,2.87,94.41,54.44,133,105.62V0H0V1920H1005.68c-4.12-16.18-7.63-32.86-11.23-49.44a203,203,0,0,0-18.67-35.07c-53.21-78.34-188.94-124.34-214.87-216.51-9.2-32.68-6.21-58.24,1.49-82.31-6.14-56.19,26.92-88.67,43.7-142.35,3.22-95.56-84.29-169.54-37.1-243.72a87.59,87.59,0,0,1,12.33-17,86.8,86.8,0,0,1,6.86-11.9c46.16-76.21,171.07-20.15,254.86-137.66.54-.77,1.07-1.55,1.58-2.34C1083.86,894.52,1006.72,688.4,1116.8,599.88Z"/>
									<path fill-opacity=".3" d="M769,1150.6a87.59,87.59,0,0,1,12.33-17c-30.56,64.42,40.55,133.24,33.29,217.62a200.78,200.78,0,0,1-8.52,43.09C809.32,1298.76,721.81,1224.78,769,1150.6ZM760.91,1619c25.93,92.17,161.66,138.17,214.87,216.51a203,203,0,0,1,18.67,35.07c-8.48-39-17.53-77.49-36.49-107.59-46.81-74.3-171.12-121.25-192.21-207.49a144.3,144.3,0,0,1-3.35-18.81C754.7,1560.74,751.71,1586.3,760.91,1619ZM1787,405.8c-179.36-9.23-198.14,150.13-290.53,173.83-95.76,24.56-276-63.12-379.65,20.25-110.08,88.52-32.94,294.64-72.17,381.83,48.1-74-25-278,83.42-359.23,98.73-73.94,262.93,13,352.44-6.66,86.38-19,108.86-166.08,274.77-151.8,73.38,6.31,111.79,103.23,164.74,160.55V511.42C1881.39,460.24,1842.63,408.67,1787,405.8Z"/>',
				),
				'default-inverted' => array(
					'landscape' => '<path fill-opacity=".3" d="M952.1,1009.94a181.86,181.86,0,0,1-7.72,39.06c2.91-86.63-76.42-153.71-33.64-221a79,79,0,0,1,11.18-15.4C894.22,871,958.69,933.43,952.1,1009.94Zm130,373.3c-42.44-67.36-155.14-109.94-174.26-188.12a133.1,133.1,0,0,1-3-17c-7,21.82-9.69,45-1.35,74.62,22.51,80,136.18,121.62,188.19,187.31h13.8C1099.67,1419.33,1092.54,1399.87,1082.06,1383.24Zm154.21-1034c89.51-67,238.38,11.83,319.54-6,78.31-17.24,98.7-150.58,249.12-137.63,49.87,4.29,81.92,54.75,115.07,101.64v-102c-24.88-28.53-52.07-50.64-86.31-52.4C1671.07,144.4,1654,288.89,1570.28,310.37c-86.82,22.27-250.21-57.22-344.21,18.37-99.8,80.25-29.86,267.12-65.43,346.18C1204.25,607.85,1138,422.83,1236.27,349.23Z"/>
									<path d="M1804.93,205.56C1654.51,192.61,1634.12,326,1555.81,343.19c-81.16,17.87-230-61-319.54,6-98.28,73.6-32,258.62-75.63,325.69-.47.71-.94,1.42-1.43,2.11-76,106.54-189.22,55.73-231.07,124.82a78.9,78.9,0,0,0-6.22,10.79c-27.7,58.4,36.77,120.79,30.18,197.3a181.86,181.86,0,0,1-7.72,39.06c-15.22,48.68-45.19,78.12-39.63,129.07a133.1,133.1,0,0,0,3,17c19.12,78.18,131.82,120.76,174.26,188.12,10.48,16.63,17.61,36.09,23.33,56.76H1920V307.2C1886.85,260.31,1854.8,209.85,1804.93,205.56Z"/>',
					'portrait'  => '<path fill-opacity=".3" d="M663.46,1640.21a102.92,102.92,0,0,1,14.5-20C642,1696,725.65,1776.91,717.1,1876.13a235.88,235.88,0,0,1-10,50.67C710.87,1814.43,608,1727.44,663.46,1640.21Zm-3.82,476.1a169.76,169.76,0,0,1-3.94-22.12c-9.06,28.3-12.57,58.35-1.76,96.79,30.5,108.37,190.1,162.47,252.67,254.59a237.7,237.7,0,0,1,21.95,41.23c-10-45.87-20.61-91.12-42.91-126.51C830.62,2272.92,684.45,2217.71,659.64,2116.31Zm426-1097.1c116.1-87,309.17,15.34,414.43-7.83,101.57-22.35,128-195.29,323.1-178.5,38.83,3.34,69.33,28.26,96.81,60.81v-109c-18.12-11.7-37.71-19.18-59.51-20.3-210.91-10.87-233,176.52-341.64,204.39-112.6,28.88-324.5-74.21-446.41,23.82-129.45,104.08-38.74,346.45-84.87,449C1044.14,1354.64,958.2,1114.68,1085.66,1019.21Z"/>
									<path d="M1823.19,832.88c-195.09-16.79-221.53,156.15-323.1,178.5-105.26,23.17-298.33-79.12-414.43,7.83-127.46,95.47-41.52,335.43-98.09,422.41-.6.93-1.22,1.85-1.86,2.75-98.52,138.17-245.4,72.27-299.68,161.88a101.63,101.63,0,0,0-8.07,14C642,1696,725.65,1776.91,717.1,1876.13a235.88,235.88,0,0,1-10,50.67c-19.73,63.13-58.6,101.31-51.39,167.39a169.76,169.76,0,0,0,3.94,22.12c24.81,101.4,171,156.61,226,244,22.3,35.39,32.94,80.64,42.91,126.51,5.37,24.7,10.55,49.58,17.25,73.2H1920V893.69C1892.52,861.14,1862,836.22,1823.19,832.88Z"/>',
					'square'    => '<path fill-opacity=".3" d="M814.62,1351.23a200.78,200.78,0,0,1-8.52,43.09c3.22-95.56-84.29-169.54-37.1-243.72a87.59,87.59,0,0,1,12.33-17C750.77,1198,821.88,1266.85,814.62,1351.23Zm-48.87,204.25a144.3,144.3,0,0,1-3.35-18.81c-7.7,24.07-10.69,49.63-1.49,82.31,25.93,92.17,161.66,138.17,214.87,216.51a203,203,0,0,1,18.67,35.07c-8.48-39-17.53-77.49-36.49-107.59C911.15,1688.67,786.84,1641.72,765.75,1555.48Zm362.3-933c98.73-73.94,262.93,13,352.44-6.66,86.38-19,108.86-166.08,274.77-151.8,73.38,6.31,111.79,103.23,164.74,160.55V511.42c-38.61-51.18-77.37-102.75-133-105.62-179.36-9.23-198.14,150.13-290.53,173.83-95.76,24.56-276-63.12-379.65,20.25-110.08,88.52-32.94,294.64-72.17,381.83C1092.73,907.74,1019.65,703.67,1128.05,622.48Z"/>
									<path d="M1755.26,464c-165.91-14.28-188.39,132.79-274.77,151.8-89.51,19.71-253.71-67.28-352.44,6.66-108.4,81.19-35.32,285.26-83.42,359.23-.51.79-1,1.57-1.58,2.34-83.79,117.51-208.7,61.45-254.86,137.66a86.8,86.8,0,0,0-6.86,11.9c-30.56,64.42,40.55,133.24,33.29,217.62a200.78,200.78,0,0,1-8.52,43.09c-16.78,53.68-49.84,86.16-43.7,142.35a144.3,144.3,0,0,0,3.35,18.81C786.84,1641.72,911.15,1688.67,958,1763c19,30.1,28,68.58,36.49,107.59,3.6,16.58,7.11,33.26,11.23,49.44H1920V624.57C1867.05,567.25,1828.64,470.33,1755.26,464Z"/>',
				),
				'rotated'          => array(
					'landscape' => '<path d="M852,649.81c-67.45-83.88,3.48-229.67-16.39-307.15-19.17-74.74-148.1-89.94-140.63-235,2.32-45,44-76.37,85.45-107.61H0V1440H1920V739.71c-13.09,3.34-26.58,6.17-40,9.09a163.76,163.76,0,0,0-28.37,15.1C1788.25,807,1751,916.76,1676.47,937.74c-26.45,7.44-47.12,5-66.59-1.21-45.47,5-71.74-21.78-115.17-35.35-77.31-2.61-137.16,68.19-197.18,30a70.27,70.27,0,0,1-13.74-10,69.73,69.73,0,0,1-9.63-5.54c-61.65-37.35-16.3-138.41-111.37-206.19-.62-.44-1.25-.87-1.89-1.28C1090.35,676.46,923.6,738.87,852,649.81Z"/>
									<path fill-opacity=".3" d="M1297.53,931.19a70.27,70.27,0,0,1-13.74-10c52.11,24.73,107.79-32.8,176.06-26.93a162.43,162.43,0,0,1,34.86,6.9C1417.4,898.57,1357.55,969.37,1297.53,931.19Zm378.94,6.55c74.56-21,111.78-130.79,175.16-173.84A163.76,163.76,0,0,1,1880,748.8c-31.56,6.86-62.69,14.18-87,29.52-60.11,37.87-98.1,138.43-167.86,155.5a116.53,116.53,0,0,1-15.22,2.71C1629.35,942.76,1650,945.18,1676.47,937.74ZM695,107.61C687.5,252.72,816.43,267.92,835.6,342.66c19.87,77.48-51.06,223.27,16.39,307.15,71.61,89.06,238.36,26.65,308.91,58.39-59.85-38.92-225,20.21-290.63-67.49-59.82-79.88,10.56-212.71-5.38-285.14C849.5,285.69,730.52,267.5,742.07,133.28,747.18,73.92,825.59,42.83,872,0H780.42C739,31.24,697.29,62.6,695,107.61Z"/>',
					'portrait'  => '<path d="M599.88,1070.93c-83.37-138.24,4.31-378.52-20.25-506.19C555.93,441.54,396.57,416.5,405.8,177.35,408.67,103.16,460.24,51.49,511.42,0H0V2560H1920V1219.1c-16.18,5.49-32.86,10.17-49.44,15a192.73,192.73,0,0,0-35.07,24.89c-78.34,71-124.34,251.92-216.51,286.5-32.68,12.26-58.24,8.28-82.31-2-56.19,8.18-88.67-35.9-142.35-58.27-95.56-4.29-169.54,112.39-243.72,49.47a94,94,0,0,1-17-16.45,84.34,84.34,0,0,1-11.9-9.14c-76.21-61.55-20.15-228.1-137.66-339.81-.77-.73-1.55-1.43-2.34-2.11C894.52,1114.85,688.4,1217.71,599.88,1070.93Z"/>
									<path fill-opacity=".3" d="M1150.6,1534.67a94,94,0,0,1-17-16.45c64.42,40.75,133.24-54.06,217.62-44.38a157.54,157.54,0,0,1,43.09,11.36C1298.76,1480.91,1224.78,1597.59,1150.6,1534.67ZM1619,1545.46c92.17-34.58,138.17-215.55,216.51-286.5a192.73,192.73,0,0,1,35.07-24.89c-39,11.31-77.49,23.37-107.59,48.65-74.3,62.41-121.25,228.15-207.49,256.28a113.2,113.2,0,0,1-18.81,4.47C1560.74,1553.74,1586.3,1557.72,1619,1545.46ZM405.8,177.35C396.57,416.5,555.93,441.54,579.63,564.74c24.56,127.67-63.12,368,20.25,506.19,88.52,146.78,294.64,43.92,381.83,96.23-74-64.14-278,33.3-359.23-111.23-73.94-131.64,13-350.56-6.66-469.92-19-115.17-166.08-145.15-151.8-366.36C470.33,121.82,567.25,70.59,624.57,0H511.42C460.24,51.49,408.67,103.16,405.8,177.35Z"/>',
					'square'    => '<path d="M599.88,803.2c-83.37-103.68,4.31-283.89-20.25-379.65C555.93,331.16,396.57,312.38,405.8,133c2.87-55.65,54.44-94.41,105.62-133H0V1920H1920V914.32c-16.18,4.12-32.86,7.63-49.44,11.23a203,203,0,0,0-35.07,18.67c-78.34,53.21-124.34,188.94-216.51,214.87-32.68,9.2-58.24,6.21-82.31-1.49-56.19,6.14-88.67-26.92-142.35-43.7-95.56-3.22-169.54,84.29-243.72,37.1a87.59,87.59,0,0,1-17-12.33,86.8,86.8,0,0,1-11.9-6.86c-76.21-46.16-20.15-171.07-137.66-254.86-.77-.54-1.55-1.07-2.34-1.58C894.52,836.14,688.4,913.28,599.88,803.2Z"/>
									<path fill-opacity=".3" d="M1150.6,1151a87.59,87.59,0,0,1-17-12.33c64.42,30.56,133.24-40.55,217.62-33.29a200.78,200.78,0,0,1,43.09,8.52C1298.76,1110.68,1224.78,1198.19,1150.6,1151Zm468.38,8.09c92.17-25.93,138.17-161.66,216.51-214.87a203,203,0,0,1,35.07-18.67c-39,8.48-77.49,17.53-107.59,36.49-74.3,46.81-121.25,171.12-207.49,192.21a144.3,144.3,0,0,1-18.81,3.35C1560.74,1165.3,1586.3,1168.29,1619,1159.09ZM405.8,133c-9.23,179.36,150.13,198.14,173.83,290.53,24.56,95.76-63.12,276,20.25,379.65,88.52,110.08,294.64,32.94,381.83,72.17-74-48.1-278,25-359.23-83.42-73.94-98.73,13-262.93-6.66-352.44-19-86.38-166.08-108.86-151.8-274.77C470.33,91.36,567.25,53,624.57,0H511.42C460.24,38.61,408.67,77.37,405.8,133Z"/>',
				),
				'rotated-inverted' => array(
					'landscape' => '<path fill-opacity=".3" d="M1497.75,968.14a181.86,181.86,0,0,1,39.06,7.72c-86.63-2.92-153.71,76.42-221,33.64a79.4,79.4,0,0,1-15.4-11.18C1358.85,1026,1421.24,961.55,1497.75,968.14Zm373.3-130c-67.36,42.44-109.93,155.14-188.12,174.26a133.1,133.1,0,0,1-17,3c21.82,7,45,9.69,74.62,1.35,80-22.51,121.62-136.18,187.31-188.19v-13.8C1907.14,820.57,1887.68,827.7,1871.05,838.18ZM837,684c-67-89.52,11.83-238.38-6-319.54-17.24-78.31-150.58-98.7-137.63-249.12C697.66,65.44,748.12,33.39,795,.24H693c-28.53,24.88-50.64,52.07-52.4,86.31C632.21,249.17,776.7,266.2,798.18,350c22.27,86.82-57.22,250.21,18.37,344.2C896.8,794,1083.67,724,1162.73,759.6,1095.66,716,910.64,782.24,837,684Z"/>
									<path d="M693.37,115.31C680.42,265.73,813.76,286.12,831,364.43c17.87,81.16-61,230,6,319.54,73.6,98.27,258.62,32,325.69,75.63.71.46,1.42.94,2.12,1.43,106.53,76,55.72,189.22,124.81,231.07a80,80,0,0,0,10.79,6.22c58.4,27.7,120.79-36.77,197.3-30.18a181.86,181.86,0,0,1,39.06,7.72c48.68,15.21,78.12,45.18,129.07,39.63a133.1,133.1,0,0,0,17-3c78.19-19.12,120.76-131.82,188.12-174.26,16.63-10.48,36.09-17.61,56.76-23.33V.24H795C748.12,33.39,697.66,65.44,693.37,115.31Z"/>',
					'portrait'  => '<path fill-opacity=".3" d="M1150.6,1534.67a94,94,0,0,1-17-16.45c64.42,40.75,133.24-54.06,217.62-44.38a157.54,157.54,0,0,1,43.09,11.36C1298.76,1480.91,1224.78,1597.59,1150.6,1534.67ZM1619,1545.46c92.17-34.58,138.17-215.55,216.51-286.5a192.73,192.73,0,0,1,35.07-24.89c-39,11.31-77.49,23.37-107.59,48.65-74.3,62.41-121.25,228.15-207.49,256.28a113.2,113.2,0,0,1-18.81,4.47C1560.74,1553.74,1586.3,1557.72,1619,1545.46ZM405.8,177.35C396.57,416.5,555.93,441.54,579.63,564.74c24.56,127.67-63.12,368,20.25,506.19,88.52,146.78,294.64,43.92,381.83,96.23-74-64.14-278,33.3-359.23-111.23-73.94-131.64,13-350.56-6.66-469.92-19-115.17-166.08-145.15-151.8-366.36C470.33,121.82,567.25,70.59,624.57,0H511.42C460.24,51.49,408.67,103.16,405.8,177.35Z"/>
									<path d="M1870.56,1234.07c-39,11.31-77.49,23.37-107.59,48.65-74.3,62.41-121.25,228.15-207.49,256.28a113.2,113.2,0,0,1-18.81,4.47c-56.19,8.18-88.67-35.9-142.35-58.27a157.54,157.54,0,0,0-43.09-11.36c-84.38-9.68-153.2,85.13-217.62,44.38a84.34,84.34,0,0,1-11.9-9.14c-76.21-61.55-20.15-228.1-137.66-339.81-.77-.73-1.55-1.43-2.34-2.11-74-64.14-278,33.3-359.23-111.23-73.94-131.64,13-350.56-6.66-469.92-19-115.17-166.08-145.15-151.8-366.36C470.33,121.82,567.25,70.59,624.57,0L1920-2V1219.1C1903.82,1224.59,1887.14,1229.27,1870.56,1234.07Z"/>',
					'square'    => '<path fill-opacity=".3" d="M1345,1103.59a200.78,200.78,0,0,1,43.09,8.52c-95.56-3.22-169.54,84.29-243.72,37.1a87.59,87.59,0,0,1-17-12.33C1191.82,1167.44,1260.64,1096.33,1345,1103.59Zm204.25,48.87a144.3,144.3,0,0,1-18.81,3.35c24.07,7.7,49.63,10.69,82.31,1.49,92.17-25.93,138.17-161.66,216.51-214.87a203,203,0,0,1,35.07-18.67c-39,8.48-77.49,17.53-107.59,36.49C1682.46,1007.06,1635.51,1131.36,1549.27,1152.46Zm-933-362.3c-73.94-98.73,13.05-262.93-6.66-352.44-19-86.38-166.08-108.86-151.8-274.77C464.12,89.57,561,51.15,618.36-1.79H505.21C454,36.82,402.46,75.58,399.6,131.22c-9.24,179.36,150.12,198.15,173.82,290.54,24.56,95.76-63.12,276,20.25,379.65,88.52,110.08,294.64,32.94,381.83,72.17C901.53,825.47,697.46,898.56,616.27,790.16Z"/>
									<path d="M457.81,163C443.53,328.86,590.6,351.34,609.61,437.72c19.71,89.51-67.28,253.71,6.66,352.44,81.19,108.4,285.26,35.31,359.23,83.42.79.51,1.57,1,2.34,1.58C1095.35,959,1039.3,1083.86,1115.5,1130a86.8,86.8,0,0,0,11.9,6.86c64.42,30.56,133.24-40.55,217.62-33.29a200.78,200.78,0,0,1,43.09,8.52c53.68,16.78,86.16,49.83,142.35,43.7a144.3,144.3,0,0,0,18.81-3.35c86.24-21.1,133.19-145.4,207.49-192.21,30.1-19,68.58-28,107.59-36.49,16.58-3.6,33.27-7.11,49.44-11.23V-1.79H618.36C561,51.15,464.12,89.57,457.81,163Z"/>									',
				),
			),
		);
	}
}

return new ET_Builder_Mask_Corner_Blob();
