<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
<?php
	elegant_description();
	elegant_keywords();
	elegant_canonical();

	/**
	 * Fires in the head, before {@see wp_head()} is called. This action can be used to
	 * insert elements into the beginning of the head before any styles or scripts.
	 *
	 * @since 1.0
	 */
	do_action( 'et_head_meta' );

	$template_directory_uri = get_template_directory_uri();
?>

	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

	<script type="text/javascript">
		document.documentElement.className = 'js';
	</script>

	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php
	wp_body_open();

	$product_tour_enabled = et_builder_is_product_tour_enabled();
	$page_container_style = $product_tour_enabled ? ' style="padding-top: 0px;"' : ''; ?>
	<div id="page-container"<?php echo et_core_intentionally_unescaped( $page_container_style, 'fixed_string' ); ?>>
<?php
	if ( $product_tour_enabled || is_page_template( 'page-template-blank.php' ) ) {
		return;
	}

	$et_secondary_nav_items = et_divi_get_top_nav_items();

	$et_phone_number = $et_secondary_nav_items->phone_number;

	$et_email = $et_secondary_nav_items->email;

	$et_contact_info_defined = $et_secondary_nav_items->contact_info_defined;

	$show_header_social_icons = $et_secondary_nav_items->show_header_social_icons;

	$et_secondary_nav = $et_secondary_nav_items->secondary_nav;

	$et_top_info_defined = $et_secondary_nav_items->top_info_defined;

	$et_slide_header = 'slide' === et_get_option( 'header_style', 'left' ) || 'fullscreen' === et_get_option( 'header_style', 'left' ) ? true : false;

	$show_search_icon = ( false !== et_get_option( 'show_search_icon', true ) && ! $et_slide_header ) || is_customize_preview();
?>

	<?php if ( $et_top_info_defined && ! $et_slide_header || is_customize_preview() ) : ?>
		<?php ob_start(); ?>
		<div id="top-header"<?php echo $et_top_info_defined ? '' : 'style="display: none;"'; ?>>
			<div class="container clearfix">

			<?php if ( $et_contact_info_defined ) : ?>

				<div id="et-info">
				<?php if ( ! empty( $et_phone_number = et_get_option( 'phone_number' ) ) ) : ?>
					<span id="et-info-phone"><?php echo et_core_esc_previously( et_sanitize_html_input_text( strval( $et_phone_number ) ) ); ?></span>
				<?php endif; ?>

				<?php if ( ! empty( $et_email = et_get_option( 'header_email' ) ) ) : ?>
					<a href="<?php echo esc_attr( 'mailto:' . $et_email ); ?>"><span id="et-info-email"><?php echo esc_html( $et_email ); ?></span></a>
				<?php endif; ?>

				<?php
				if ( true === $show_header_social_icons ) {
					get_template_part( 'includes/social_icons', 'header' );
				} ?>
				</div>

			<?php endif; // true === $et_contact_info_defined ?>

				<div id="et-secondary-menu">
				<?php
					if ( ! $et_contact_info_defined && true === $show_header_social_icons ) {
						get_template_part( 'includes/social_icons', 'header' );
					} else if ( $et_contact_info_defined && true === $show_header_social_icons ) {
						ob_start();

						get_template_part( 'includes/social_icons', 'header' );

						$duplicate_social_icons = ob_get_contents();

						ob_end_clean();

						printf(
							'<div class="et_duplicate_social_icons">
								%1$s
							</div>',
							et_core_esc_previously( $duplicate_social_icons )
						);
					}

					if ( '' !== $et_secondary_nav ) {
						echo et_core_esc_wp( $et_secondary_nav );
					}

					et_show_cart_total();
				?>
				</div>

			</div>
		</div>
	<?php
		$top_header = ob_get_clean();

		/**
		 * Filters the HTML output for the top header.
		 *
		 * @since 3.10
		 *
		 * @param string $top_header
		 */
		echo et_core_intentionally_unescaped( apply_filters( 'et_html_top_header', $top_header ), 'html' );
	?>
	<?php endif; // true ==== $et_top_info_defined ?>

	<?php if ( $et_slide_header || is_customize_preview() ) : ?>
		<?php ob_start(); ?>
		<div class="et_slide_in_menu_container">
			<?php if ( 'fullscreen' === et_get_option( 'header_style', 'left' ) || is_customize_preview() ) { ?>
				<span class="mobile_menu_bar et_toggle_fullscreen_menu"></span>
			<?php } ?>

			<?php
				if ( $et_contact_info_defined || true === $show_header_social_icons || false !== et_get_option( 'show_search_icon', true ) || class_exists( 'woocommerce' ) || is_customize_preview() ) { ?>
					<div class="et_slide_menu_top">

					<?php if ( 'fullscreen' === et_get_option( 'header_style', 'left' ) ) { ?>
						<div class="et_pb_top_menu_inner">
					<?php } ?>
			<?php }

				if ( true === $show_header_social_icons ) {
					get_template_part( 'includes/social_icons', 'header' );
				}

				et_show_cart_total();
			?>
			<?php if ( false !== et_get_option( 'show_search_icon', true ) || is_customize_preview() ) : ?>
				<?php if ( 'fullscreen' !== et_get_option( 'header_style', 'left' ) ) { ?>
					<div class="clear"></div>
				<?php } ?>
				<form role="search" method="get" class="et-search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<?php
						printf( '<input type="search" class="et-search-field" placeholder="%1$s" value="%2$s" name="s" title="%3$s" />',
							esc_attr__( 'Search &hellip;', 'Divi' ),
							get_search_query(),
							esc_attr__( 'Search for:', 'Divi' )
						);

						/**
						 * Fires inside the search form element, just before its closing tag.
						 *
						 * @since ??
						 */
						do_action( 'et_search_form_fields' );
					?>
					<button type="submit" id="searchsubmit_header"></button>
				</form>
			<?php endif; // true === et_get_option( 'show_search_icon', false ) ?>

			<?php if ( $et_contact_info_defined ) : ?>

				<div id="et-info">
				<?php if ( ! empty( $et_phone_number = et_get_option( 'phone_number' ) ) ) : ?>
					<span id="et-info-phone"><?php echo et_core_esc_previously( et_sanitize_html_input_text( strval( $et_phone_number ) ) ); ?></span>
				<?php endif; ?>

				<?php if ( ! empty( $et_email = et_get_option( 'header_email' ) ) ) : ?>
					<a href="<?php echo esc_attr( 'mailto:' . $et_email ); ?>"><span id="et-info-email"><?php echo esc_html( $et_email ); ?></span></a>
				<?php endif; ?>
				</div>

			<?php endif; // true === $et_contact_info_defined ?>
			<?php if ( $et_contact_info_defined || true === $show_header_social_icons || false !== et_get_option( 'show_search_icon', true ) || class_exists( 'woocommerce' ) || is_customize_preview() ) { ?>
				<?php if ( 'fullscreen' === et_get_option( 'header_style', 'left' ) ) { ?>
					</div>
				<?php } ?>

				</div>
			<?php } ?>

			<div class="et_pb_fullscreen_nav_container">
				<?php
					$slide_nav = '';
					$slide_menu_class = 'et_mobile_menu';

					$slide_nav = wp_nav_menu( array( 'theme_location' => 'primary-menu', 'container' => '', 'fallback_cb' => '', 'echo' => false, 'items_wrap' => '%3$s' ) );
					$slide_nav .= wp_nav_menu( array( 'theme_location' => 'secondary-menu', 'container' => '', 'fallback_cb' => '', 'echo' => false, 'items_wrap' => '%3$s' ) );
				?>

				<ul id="mobile_menu_slide" class="<?php echo esc_attr( $slide_menu_class ); ?>">

				<?php
					if ( '' === $slide_nav ) :
				?>
						<?php if ( 'on' === et_get_option( 'divi_home_link' ) ) { ?>
							<li <?php if ( is_home() ) echo( 'class="current_page_item"' ); ?>><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'Divi' ); ?></a></li>
						<?php }; ?>

						<?php show_page_menu( $slide_menu_class, false, false ); ?>
						<?php show_categories_menu( $slide_menu_class, false ); ?>
				<?php
					else :
						echo et_core_esc_wp( $slide_nav ) ;
					endif;
				?>

				</ul>
			</div>
		</div>
	<?php
		$slide_header = ob_get_clean();

		/**
		 * Filters the HTML output for the slide header.
		 *
		 * @since 3.10
		 *
		 * @param string $top_header
		 */
		echo et_core_intentionally_unescaped( apply_filters( 'et_html_slide_header', $slide_header ), 'html' );
	?>
	<?php endif; // true ==== $et_slide_header ?>

	<?php ob_start(); ?>
		<header id="main-header" data-height-onload="<?php echo esc_attr( et_get_option( 'menu_height', '66' ) ); ?>">
			<div class="container clearfix et_menu_container">
			<?php
				$logo = ( $user_logo = et_get_option( 'divi_logo' ) ) && ! empty( $user_logo )
					? $user_logo
					: $template_directory_uri . '/images/logo.png';

				// Get logo image size based on attachment URL.
				$logo_size   = et_get_attachment_size_by_url( $logo );
				$logo_width  = ( ! empty( $logo_size ) && is_numeric( $logo_size[0] ) )
						? $logo_size[0]
						: '93'; // 93 is the width of the default logo.
				$logo_height = ( ! empty( $logo_size ) && is_numeric( $logo_size[1] ) )
						? $logo_size[1]
						: '43'; // 43 is the height of the default logo.

				ob_start();
			?>
				<div class="logo_container">
					<span class="logo_helper"></span>
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
						<img src="<?php echo esc_attr( $logo ); ?>" width="<?php echo esc_attr( $logo_width ); ?>" height="<?php echo esc_attr( $logo_height ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>" id="logo" data-height-percentage="<?php echo esc_attr( et_get_option( 'logo_height', '54' ) ); ?>" />
					</a>
				</div>
			<?php
				$logo_container = ob_get_clean();

				/**
				 * Filters the HTML output for the logo container.
				 *
				 * @since 3.10
				 *
				 * @param string $logo_container
				 */
				echo et_core_intentionally_unescaped( apply_filters( 'et_html_logo_container', $logo_container ), 'html' );
			?>
				<div id="et-top-navigation" data-height="<?php echo esc_attr( et_get_option( 'menu_height', '66' ) ); ?>" data-fixed-height="<?php echo esc_attr( et_get_option( 'minimized_menu_height', '40' ) ); ?>">
					<?php if ( ! $et_slide_header || is_customize_preview() ) : ?>
						<nav id="top-menu-nav">
						<?php
							$menuClass = 'nav';
							if ( 'on' === et_get_option( 'divi_disable_toptier' ) ) $menuClass .= ' et_disable_top_tier';
							$primaryNav = '';

							$primaryNav = wp_nav_menu( array( 'theme_location' => 'primary-menu', 'container' => '', 'fallback_cb' => '', 'menu_class' => $menuClass, 'menu_id' => 'top-menu', 'echo' => false ) );
							if ( empty( $primaryNav ) ) :
						?>
							<ul id="top-menu" class="<?php echo esc_attr( $menuClass ); ?>">
								<?php if ( 'on' === et_get_option( 'divi_home_link' ) ) { ?>
									<li <?php if ( is_home() ) echo( 'class="current_page_item"' ); ?>><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'Divi' ); ?></a></li>
								<?php }; ?>

								<?php show_page_menu( $menuClass, false, false ); ?>
								<?php show_categories_menu( $menuClass, false ); ?>
							</ul>
						<?php
							else :
								echo et_core_esc_wp( $primaryNav );
							endif;
						?>
						</nav>
					<?php endif; ?>

					<?php
					if ( ! $et_top_info_defined && ( ! $et_slide_header || is_customize_preview() ) ) {
						et_show_cart_total( array(
							'no_text' => true,
						) );
					}
					?>

					<?php if ( $et_slide_header || is_customize_preview() ) : ?>
						<span class="mobile_menu_bar et_pb_header_toggle et_toggle_<?php echo esc_attr( et_get_option( 'header_style', 'left' ) ); ?>_menu"></span>
					<?php endif; ?>

					<?php if ( $show_search_icon ) : ?>
						<div id="et_top_search">
							<span id="et_search_icon"></span>
						</div>
					<?php endif; ?>

					<?php

					/**
					 * Fires at the end of the 'et-top-navigation' element, just before its closing tag.
					 *
					 * @since 1.0
					 */
					do_action( 'et_header_top' );

					?>
				</div> <!-- #et-top-navigation -->
			</div> <!-- .container -->
			<?php if ( $show_search_icon ) : ?>
			<div class="et_search_outer">
				<div class="container et_search_form_container">
					<form role="search" method="get" class="et-search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<?php
						printf( '<input type="search" class="et-search-field" placeholder="%1$s" value="%2$s" name="s" title="%3$s" />',
							esc_attr__( 'Search &hellip;', 'Divi' ),
							get_search_query(),
							esc_attr__( 'Search for:', 'Divi' )
						);

						/**
						 * Fires inside the search form element, just before its closing tag.
						 *
						 * @since ??
						 */
						do_action( 'et_search_form_fields' );
					?>
					</form>
					<span class="et_close_search_field"></span>
				</div>
			</div>
			<?php endif; ?>
		</header> <!-- #main-header -->
	<?php
		$main_header = ob_get_clean();

		/**
		 * Filters the HTML output for the main header.
		 *
		 * @since 3.10
		 *
		 * @param string $main_header
		 */
		echo et_core_intentionally_unescaped( apply_filters( 'et_html_main_header', $main_header ), 'html' );
	?>
		<div id="et-main-area">
<!-------------------- Content here: ------------------------->
<?php 
    wp_enqueue_style('custom-style', get_stylesheet_directory_uri() . '/migratecss/style.css');
    wp_enqueue_style('custom-style', get_stylesheet_directory_uri() . '/migratecss/animate.min.css');
    wp_enqueue_style('custom-style', get_stylesheet_directory_uri() . '/migratecss/font-awesome.min.css');
    wp_enqueue_style('custom-style', get_stylesheet_directory_uri() . '/migratecss/flexslider.css');
    wp_enqueue_style('custom-style', get_stylesheet_directory_uri() . '/migratecss/owl.carousel.css');
    wp_enqueue_style('custom-style', get_stylesheet_directory_uri() . '/migratecss/owl.theme.default.css');
    wp_enqueue_style('custom-style', get_stylesheet_directory_uri() . '/migratecss/carousel-slider.css');
    wp_enqueue_style('custom-style', get_stylesheet_directory_uri() . '/migratecss/theme-corporate.css');
    wp_enqueue_style('custom-style', get_stylesheet_directory_uri() . '/migratecss/responsive.css');
?>
    <link href="migratecss/font-awesome.min.css" rel="stylesheet">
    <link href="migratecss/magnific-popup.css" rel="stylesheet">
    <link href="migratecss/flexslider.css" rel="stylesheet">
    <link href="migratecss/owl.carousel.css" rel="stylesheet">
    <link href="migratecss/owl.theme.default.css" rel="stylesheet">
    <link href="migratecss/carousel-slider.css" rel="stylesheet">
    <link href="migratecss/style.css" rel="stylesheet">
    <link href="migratecss/theme-corporate.css" rel="stylesheet">
    <link href="migratecss/responsive.css" rel="stylesheet">

<!doctype html>
<html lang="en">

<head>

    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <meta name="title" content="Home | CEM Benchmarking" />
    <title>Home | CEM Benchmarking</title>
    <meta name="description"
          content="We have been collecting detailed cost and performance data from the world’s top pension and sovereign wealth funds for 25 years and providing deep expertise and insight." />
    <link href="https://fonts.googleapis.com/css?family=Barlow" rel="stylesheet">
    <link href="img/browser-tab-icon.png" rel="shortcut icon" type="image/png">

    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i,800|Raleway:100,200,300,400,600,700,800"
          rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Barlow:100, 200, 300, 400,500,600" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css?family=Noto+Sans+KR:100,300,400,500,700" rel="stylesheet">
    <!-- Google Tag Manager -->
    <script>
    (function (w, d, s, l, i) {
            w[l] = w[l] || []; w[l].push({
                'gtm.start':
                    new Date().getTime(), event: 'gtm.js'
            }); var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s), dl = l != 'dataLayer' ? '&l=' + l : ''; j.async = true; j.src =
                    'https://www.googletagmanager.com/gtm.js?id=' + i + dl; f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-KR9H483');</script>
    <!-- End Google Tag Manager -->
</head>
<!--=======TOM PROFILE=========-->


<body>
    <!-- Google Tag Manager (noscript) -->
    <noscript>
        <iframe src="https://www.googletagmanager.com/ns.html?id=GTM-KR9H483"
                height="0" width="0" style="display:none;visibility:hidden"></iframe>
    </noscript>
    <!-- End Google Tag Manager (noscript) -->
    <header id="header-megamenu">
        <!--*-*-*-*-*-*-*-*-*-*- NAVIGATION BAR *-*-*-*-*-*-*-*-*-*-->
        <div id="header-nav"></div>
        <!--*-*-*-*-*-*-*-*-*-*- END NAVIGATION BAR *-*-*-*-*-*-*-*-*-*-->

        <div class="owl-half-screen">
            <div class="owl-cover owl-content overlay-dark"
                 style="background: url(img/hero/section2.jpg);background-attachment: fixed;background-size: cover;">
                <div class="owl-content-des header-tit">
                    <div class="home-page-titles">
                        <h1 class="intro-heading ">Helping funds manage costs <br />and optimize performance</h1>

                        <p class="summary ">
                            CEM works with over 400 fund sponsors worldwide. We provide our clients
                            with objective, actionable <br />benchmarking insight into how to maximize value for money
                            in
                            investments and pension administration.
                        </p>

                        <a href="#about" class="page-scroll other-buttons animated-item-1">Our Services</a>
                    </div>
                </div>
            </div>
        </div>

        <!--*-*-*-*-*-*-*-*-*-*- Modal Sections *-*-*-*-*-*-*-*-*-*-->
        <div id="login-modal"></div>
        <div id="profile-modals"></div>
        <!--*-*-*-*-*-*-*-*-*-*- End Modal Sections *-*-*-*-*-*-*-*-*-*-->

    </header>
    <!--*-*-*-*-*-*-*-*-*-*- End Header Section *-*-*-*-*-*-*-*-*-*-->

    <div class="theme-corporate">
        <section class="cover-bg txt-light">
            <div class="pad-t-10 pad-b-20 pad-section-50">
                <div class="container">
                    <div class="row">
                        <div class="text-center">
                            <div class="col-md-3 col-sm-3">
                                <div class="counter-3-wrap">
                                    <div class="counter counter-number">25</div>
                                    <div class="counter-text font-size-20">Countries</div>
                                    <!-- <sup class="font-size-30">+</sup> -->
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-3">
                                <div class="counter-3-wrap">
                                    <div class="counter counter-number">15</div>
                                    <div class="counter-text font-size-20">Trillion Participating Assets</div>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-3">
                                <div class="counter-3-wrap">
                                    <div class="counter counter-number">80</div>
                                    <div class="counter-text font-size-20">Million Members</div>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-3">
                                <div class="counter-3-wrap">
                                    <div class="counter counter-number">27</div>
                                    <div class="counter-text font-size-20">Years of History</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section id="global" class="dark-bg bg-global grow animated ">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="dimmer compact">

                            <div id="cem-world" class="grow animated ">
                                <div class="loading">
                                    <i class="icon-spinner icon-spin icon-large"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section id="about" class="about bg-gray">
            <div class="container" style="padding-bottom:50px">
                <div class="row">
                    <div class="heading-wrap">
                        <h2 class="heading-title">Our Services</h2>
                    </div>
                </div>
                <div class="row" >
                    <div class="col-md-2 text-center">
                        <div class="mz-module-about">
                            <div class="small-card">
                                <div class="container-card">
                                    <h3>Investment <br> Benchmarking</h3>
                                    <ul class="service-list" style="padding-inline-start: 25px;">
[O                                        <li>Defined Benefit Funds</li>
                                        <li>Sovereign Wealth Funds </li>
                                        <li>Other long-term asset <br /> owners</li>
                                    </ul>
                                </div>
                                <a href="ibs.html" class="btn btn-clear">Learn More</a>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-2 text-center">
                        <div class="mz-module-about">
                            <div class="small-card ">
                                <div class="container-card">
                                    <h3>Pension Administration Benchmarking</h3>
                                    <span style="font-family:'barlow';padding-left:30px; padding-right:30px;text-align: center">
                                        Administrators
                                        of Defined Benefit
                                        and Defined Contribution Funds
                                    </span>
                                </div>
                                <a href="pabs.html" class="btn btn-clear">Learn More</a>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-2 text-center">
                        <div class="mz-module-about">
                            <div class="small-card">
                                <div class="container-card">
                                    <h3>Defined<br /> Contribution Benchmarking </h3>
                                    <span style="font-family:'barlow';padding-left:30px; padding-right:30px;text-align: center">
                                        U.S.
                                        Corporate and Public Defined Contribution Plans, 401(k), 403(b), 457, and
                                        other
                                    </span>
                                </div>
                                <a href="dc.html" class="btn btn-clear">Learn More</a>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-2 text-center">
                        <div class="mz-module-about">
                            <div class="small-card">
                                <div class="container-card">
                                    <h3>Global Leaders Investment Benchmarking</h3>
                                    <span style="font-family:'barlow';padding-left:30px; padding-right:30px;text-align: center">
                                        Large
                                        funds with complex investment programs
                                    </span>
                                </div>
                                <a href="gl.html" class="btn btn-clear">Learn More</a>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-2 text-center">
                        <div class="mz-module-about">
                            <div class="small-card">
                                <div class="container-card">
                                    <h3>Transparency Benchmarking</h3>
                                    <ul class="service-list" style="padding-inline-start: 25px;">
                                        <li>Pension Funds</li>
                                        <li>Sovereign Wealth Funds </li>
                                        <li>Other long-term asset <br /> owners</li>
                                    </ul>
                                </div>
                                <a href="gptb.html" class="btn btn-clear">Learn More</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>

        <section class="taglines pad-b-50 pad-t-20">
            <img src="img/benefits-molecule.jpg" class="taglines-bg">
            <div class="container">

                <div class="row">
                    <div class="heading-wrap">
                        <h2 class="heading-title">Why CEM?</h2>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-7">

                        <div class="row pad-b-10">
                            <div class="col-md-10 media">
                                <div class="media-left media-middle text-center">
                                </div>
                                <div class="media-body">
                                    <h4 class="media-heading tagline-titles">Unique Global Databases</h4>
                                    <span class="benefit-paragraph">
                                        We have been collecting detailed cost and
                                        performance data from the world’s top
                                        pension and sovereign wealth
                                        funds for over 25 years.
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="row pad-b-10">
                            <div class="col-md-10 media">
                                <div class="media-left media-middle text-center">
                                </div>
                                <div class="media-body">
                                    <h4 class="media-heading tagline-titles">
                                        Comprehensive Analysis and Reporting
                                    </h4>
                                    <span class="benefit-paragraph">
                                        Our reports and insights provide actionable insights
                                        and are used strategically
                                        as well as to help meet fiduciary
                                        responsibilities.
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="row pad-b-10">
                            <div class="col-md-10 media">
                                <div class="media-left media-middle text-center">
                                </div>
                                <div class="media-body">
                                    <h4 class="media-heading tagline-titles">Knowledge Sharing</h4>
                                    <span class="benefit-paragraph">
                                        We work closely with hundreds of expert pension
                                        practitioners worldwide and are
                                        in a unique position to capture
                                        and share this expertise amongst our clients.
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="row pad-b-10">
                            <div class="col-md-10 media">
                                <div class="media-left media-middle text-center">

                                </div>
                                <div class="media-body">
                                    <h4 class="media-heading tagline-titles">Independent and Objective</h4>
                                    <span class="benefit-paragraph">
                                        Benchmarking pension and sovereign wealth funds is
                                        all we do. We do not manage
                                        assets.
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="row pad-b-10">
                            <div class="col-md-10 media">
                                <div class="media-left media-middle text-center">
                                </div>
                                <div class="media-body">
                                    <h4 class="media-heading tagline-titles">Confidentiality</h4>
                                    <span class="benefit-paragraph">
                                        The information that CEM collects is sensitive. We
                                        are very careful about how we
                                        handle it. We do not disclose
                                        individual fund data or results to third parties.
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section id="about" class="about bg-gray pad-b-50 pad-t-20">
            <div class="container">

                <div class="row">
                    <div class="heading-wrap">
                        <h2 class="heading-title">Our Team</h2>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-3 text-center">
                        <div class="mz-module-about">
                            <div class="card-profiles" data-toggle="modal" data-target="#rashayModal"
                                 style="cursor: pointer">
                                <div class="people-card-home">
                                    <div>
                                        <img class="profile-circle" src="img/team/final/Rashay.jpg"
                                             alt="Headshot of Rashay Jethalal">
                                    </div>
                                    <h3 style="margin-top:40px">Rashay Jethalal</h3>
                                    <h4>CEO</h4>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-3 text-center">
                        <div class="mz-module-about">
                            <div class="card-profiles" data-toggle="modal" data-target="#mikeModal"
                                 style="cursor: pointer">
                                <!-- make sure all cards are consistent once i do the final copy -->
                                <div class="people-card-home">
                                    <div>
                                        <img src="img/team/final/Mike-Heale.jpg" class="profile-circle"
                                             alt="Headshot of Mike Heale">
                                    </div>
                                    <h3 style="margin-top:40px">Mike Heale</h3>
                                    <h4>Global Business Development</h4>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div style="text-align: center">
                    <div style="text-align: center;margin-top: 15px; display: inline-block; ">
                        <a href="./team.html" class="other-buttons">Meet Our Team</a>
                    </div>
                </div>
            </div>
        </section>

        <section class="testimonial-2 pad-b-50 pad-t-20"
                 style="background: url(img/benefits-section-final.jpg);background-position: 50% 50%;background-size: cover;background-attachment: fixed ">
            <div class=" text-center">
                <div class="container">
                    <div class="row">
                        <div class="heading-wrap">
                            <h2 class="heading-title">Client Testimonials</h2>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-8 col-md-offset-2">
                            <div class="testimonial owl-carousel owl-theme"
                                 style="color:rgb(80, 80, 80);font-family:'barlow'">
                                <div>
                                    <i class="fa fa-quote-left fa-3x" aria-hidden="true"></i>
                                    <p class="comments font-i">
                                        The CEM Pension Administration Benchmarking report and
                                        other services offered by CEM play an important role in our
                                        continuous process improvement program. We implemented numerous
                                        customer service initiatives during the past several years as a
                                        result of our partnership with CEM. Our members and employers have
                                        benefited from our participation.

                                    </p>
                                    <div class="line-orange-c"></div>
                                    <h2>Dan Duquette</h2>
                                    <p class="app">
                                        Deputy Executive Director | Illinois Municipal Retirement Fund
                                    </p>
                                </div>
                                <div>
                                    <i class="fa fa-quote-left fa-3x" aria-hidden="true"></i>
                                    <p class="comments font-i">
                                        The CEM benchmarking study provides us with useful,
                                        timely and relevant data in order to compare ourselves with industry peers
                                        around the world. It is far superior to any other benchmarking exercise we've
                                        seen. In addition, the professional staff at CEM are always looking for ways to
                                        improve the study and to provide additional services to their clients
                                        (conferences, peer networks, etc.). We have benefited significantly from the
                                        experience.
                                    </p>
                                    <div class="line-orange-c"></div>
                                    <h2>Rosemarie McClean</h2>
                                    <p class="app">Chief Operations Officer | Ontario Teachers' Pension Plan</p>
                                </div>
                                <div>
                                    <i class="fa fa-quote-left fa-3x" aria-hidden="true"></i>
                                    <p class="comments font-i">
                                        CEM - don't try to manage a pension plan without it. The
                                        CEM comprehensive report tells us where we stand, how we can improve and gauges
                                        the effectiveness of our investment operation against a global set of peers.
                                    </p>
                                    <div class="line-orange-c"></div>
                                    <h2>Christopher J. Ailman</h2>
                                    <p class="app">
                                        Chief Investment Officer | California State Teachers’ Retirement
                                        System (CalSTRS)
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!--<section class="pad-b-50 pad-t-20  bg-gray">
            <div class="container">
                <div class="row">
                    <div class="heading-wrap">
                        <h2 class="heading-title">Trusted Industry Leader</h2>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 col-md-offset-3" style="text-align: center;"><span
                            style="font-family: 'barlow'; font-size: 15px;color:rgb(73, 73, 73);">Over 700 of the
                            world’s most
                            influential funds rely on CEM’s valuable insights to better manage their business. Many have
                            participated for over 10 consecutive years.</span>
                    </div>
                    <div class="col-md-12" style="padding:0 0 0 0!important">
                        <div class="row-logos">
                            <div class="col-md-12" style="padding:0 0 0 0!important">
                                <img class="logo-spacing" src="img/client_logos/calpers-logo.png" alt="Snow">
                                <img class="logo-spacing" src="img/client_logos/trs-header-logo.png" alt="Mountains">

                                <img class="logo-spacing" src="img/client_logos/ipers_logo_0.png" alt="Forest">
                                <img class="logo-spacing" src="img/client_logos/trs-header-logo.png" alt="Mountains">
                                <img class="logo-spacing" src="img/client_logos/logo.png"
                                    alt="Health Association Nova Scotia">
                                <img class="logo-spacing" src="img/client_logos/ers-logo90x50.png" alt="Mountains">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>-->
    </div>

    <div id="contact-us-footer"></div>

    <a href="#0">
        <i class="cd-top cd-is-visible"><i>
    </a>
    <!-- scripts -->

    <script src="js/jquery.2.2.1.min.js"></script>

    <script>
        $(function () {
            $("#header-nav").load("./header-navbar.html", function() {
                $(".home-dd").addClass("active");
            });

            $("#contact-us-footer").load("./contact-us-footer.html");
            $("#profile-modals").load("./modals/profile-modals.html");


        });
    </script>

    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <script src="js/waypoints.2.0.3.min.js"></script>
    <script src="js/jquery.counterup.js"></script>
    <script src="js/owl.carousel.min.js"></script>
    <script src="js/jquery.downCount.js"></script>
    <script src="js/jquery.touchSwipe.min.js"></script>
    <!-- Touch Devices -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.12.4/js/bootstrap-select.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.3/jquery.easing.min.js"></script>

    <script src="https://code.highcharts.com/highcharts.js"></script>
    <script src="https://code.highcharts.com/modules/exporting.js"></script>
    <script src="https://code.highcharts.com/maps/modules/map.js"></script>

    <script src="https://code.highcharts.com/maps/modules/data.js"></script>
    <script src="https://code.highcharts.com/mapdata/custom/world.js"></script>
    <script src="js/site.js"></script>
    <script type="text/javascript">
        (function (e, t, o, n, p, r, i) { e.visitorGlobalObjectAlias = n; e[e.visitorGlobalObjectAlias] = e[e.visitorGlobalObjectAlias] || function () { (e[e.visitorGlobalObjectAlias].q = e[e.visitorGlobalObjectAlias].q || []).push(arguments) }; e[e.visitorGlobalObjectAlias].l = (new Date).getTime(); r = t.createElement("script"); r.src = o; r.async = true; i = t.getElementsByTagName("script")[0]; i.parentNode.insertBefore(r, i) })(window, document, "https://diffuser-cdn.app-us1.com/diffuser/diffuser.js", "vgo");
        vgo('setAccount', '224439273');
        vgo('setTrackByDefault', true);

        vgo('process');
    </script>
</body>

</html>
<!-------------------- Content here: ------------------------->

<h1>Junior is here</h1>
	<?php
		/**
		 * Fires after the header, before the main content is output.
		 *
		 * @since 3.10
		 */
		do_action( 'et_before_main_content' );
