

// Test 2
$.getJSON('/cem-world-data.json', function (data) {

    // Initiate the chart
    Highcharts.mapChart('cem-world', {

        chart: {
            height: "40%",
            map: "custom/world", 


        },

        legend: {
            enabled: false
        },
        title: {
            text: null
        },

        credits: {
            enabled: false
        },

        exporting: {
            enabled: false
        },

        tooltip: {
            enabled: false,
            crosshairs: false
        },

        mapNavigation: {
            enabled: false,
            buttonOptions: {
                verticalAlign: "bottom"
            }
        },
        plotOptions: {
            series: {
                enableMouseTracking: false,
                dataLabels: {
                    useHtml: true,
                    align: 'center',
                    formatter: function () {
                        return this.point.code4;// this.point.code; //+ this.point.fundCount;
                    },
                    // align: 'center',
    
                    enabled: true,
    
                    style: {
                        fontWeight: '600',
                        color: '#d5e8ff',//425b63d4
                        fontSize: '12px',
                        textOutline: false,
                        fontFamily: 'Raleway'
    
                    }
                },
                
    
            }
        },
    
        colorAxis: {
            min: 1,
            max: 1000,
            type: 'logarithmic',
            minColor: '#add8e6',
            // pink blue scheme
            // minColor: '#84dafb',
            //             maxColor: '#f1a4eb'
        },

        series: [
            {
                useHTML: true,
                borderColor: "#608cd5",
                // borderColor: '#8695ad',


                // mapData: Highcharts.maps['custom/world'],
                data: data,
                joinBy: ['iso-a2', 'code'],
                states: {
                    hover: {
                        enabled: false
                    }
                }
              
            },
        {
            useHTML: true,
            // mapData: Highcharts.maps['custom/world'],
            type: "mapbubble",
            name: '<span>Fixed Income</span><br><span style="color: transparent;">iiiiii</span><span>Funds</span>',
            joinBy: ["iso-a3", "code3"],
            data: [
                {
                    code3: "ABW",
                    z: 105,
                    code: "AW",

                },
                {
                    code3: "FIN",
                    z: 323128,
                    // code: "<span style=text-align: center> EU 78 funds, <br/> $3.22 trillion in assets </span>",
                    code4: '<span style="color: transparent;">------</span><span>115 funds</span><br><span>$3.5 trillion in assets</span>',

                },

                {
                    code3: "IDN",
                    z: 261115,
                    code4: '<span style="color: transparent;">-------</span><span>10 funds</span><br><span>$1 trillion in assets</span>'
                },
                {
                    code3: "USA",
                    z: 323128,
                    // code: "253 funds",// <br/> $4,95 trillion in assets
                    code4: '<span style="color: transparent;">------</span><span>400 funds</span><br><span>$10 trillion in assets</span>'
                },
            
                {
                    // code3: "BRA",
                    // z: 323128,
                    // code4: '<span style="color: transparent;">-------</span><span>47 funds</span><br><span>$0.49 trillion in assets</span>'

                }
            ],
            states: {
                hover: {
                    enabled: false
                }
            },
            color: "rgba(227, 237, 241, 0.53);",
            // color: "rgba(251, 221, 176, 0.65);",
            // color: "rgba(255, 220, 178, 0.7294117647058823)",
            marker:{
                fillOpacity: "0.65"
            },
            minSize: "25%",
            maxSize: "32%"
        },
        
        ]
    });
});
